/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import shaded.org.hsqldb.lib.AbstractReadOnlyCollection;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.Map;
import shaded.org.hsqldb.lib.MapEntry;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.map.BaseHashMap;

public class IntValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<K, Integer>> entries;

    public IntValueHashMap() {
        this(8);
    }

    public IntValueHashMap(int n) throws IllegalArgumentException {
        super(n, 3, 1, false);
    }

    public boolean containsKey(Object object) {
        return super.containsObjectKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsValue(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n) {
        return super.containsValue(n);
    }

    public int get(Object object) throws NoSuchElementException {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(object);
        if (n != -1) {
            return this.intValueTable[n];
        }
        throw new NoSuchElementException();
    }

    public int get(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        return n;
    }

    public boolean get(Object object, int[] nArray) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(object);
        if (n != -1) {
            nArray[0] = this.intValueTable[n];
            return true;
        }
        return false;
    }

    public Object getKey(int n) {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this, false);
        while (baseHashIterator.hasNext()) {
            int n2 = baseHashIterator.nextInt();
            if (n2 != n) continue;
            return this.objectKeyTable[baseHashIterator.getLookup()];
        }
        return null;
    }

    public boolean put(K k, int n) {
        if (k == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.addOrUpdate(0L, n, k, null);
        return n2 != this.size();
    }

    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.size();
        super.remove(0L, 0L, object, null, false, false);
        return n != this.size();
    }

    public void putAll(IntValueHashMap<K> intValueHashMap) {
        Iterator iterator = intValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.put(e, intValueHashMap.get(e));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    class Values
    extends AbstractReadOnlyCollection<Integer> {
        Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            Objects.requireNonNull(intValueHashMap);
            return new BaseHashMap.BaseHashIterator(intValueHashMap, false);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    class KeySet
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            Objects.requireNonNull(intValueHashMap);
            return new BaseHashMap.BaseHashIterator(intValueHashMap, true);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<K, Integer> next() {
            Object object = super.next();
            Integer n = IntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Object, Integer>(object, n);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Integer>>
    implements Set<Map.Entry<K, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

