/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import shaded.org.hsqldb.lib.InputStreamInterface;

public class InputStreamWrapper
implements InputStreamInterface {
    InputStream is;
    long limitSize = -1L;
    long fetchedSize = 0L;

    public InputStreamWrapper(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        int n = this.is.read();
        if (n < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        ++this.fetchedSize;
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)n2) {
            n2 = (int)(this.limitSize - this.fetchedSize);
        }
        if ((n3 = this.is.read(byArray, n, n2)) < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        this.fetchedSize += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void setSizeLimit(long l) {
        this.limitSize = l;
    }

    @Override
    public long getSizeLimit() {
        return this.limitSize;
    }
}

