/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.TableDerived;

public interface RangeGroup {
    public static final RangeGroup emptyGroup = new RangeGroupEmpty();
    public static final RangeGroup[] emptyArray = new RangeGroup[]{emptyGroup};

    public RangeVariable[] getRangeVariables();

    public void setCorrelated();

    public boolean isVariable();

    public static class RangeGroupEmpty
    implements RangeGroup {
        RangeGroupEmpty() {
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return RangeVariable.emptyArray;
        }

        @Override
        public void setCorrelated() {
        }

        @Override
        public boolean isVariable() {
            return false;
        }
    }

    public static class RangeGroupSimple
    implements RangeGroup {
        final RangeVariable[] ranges;
        final RangeGroup baseGroup;
        final TableDerived table;
        final boolean isVariable;

        public RangeGroupSimple(TableDerived tableDerived) {
            this.ranges = RangeVariable.emptyArray;
            this.baseGroup = null;
            this.table = tableDerived;
            this.isVariable = false;
        }

        public RangeGroupSimple(RangeVariable[] rangeVariableArray, RangeGroup rangeGroup) {
            this.ranges = rangeVariableArray;
            this.baseGroup = rangeGroup;
            this.table = null;
            this.isVariable = false;
        }

        public RangeGroupSimple(RangeVariable[] rangeVariableArray, boolean bl) {
            this.ranges = rangeVariableArray;
            this.baseGroup = null;
            this.table = null;
            this.isVariable = bl;
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return this.ranges;
        }

        @Override
        public void setCorrelated() {
            if (this.baseGroup != null) {
                this.baseGroup.setCorrelated();
            }
            if (this.table != null) {
                this.table.setCorrelated();
            }
        }

        @Override
        public boolean isVariable() {
            return this.isVariable;
        }
    }
}

