/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.FunctionSQLInvoked;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.navigator.RowSetNavigator;
import shaded.org.hsqldb.navigator.RowSetNavigatorData;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.types.RowType;
import shaded.org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression[] expressionArray, boolean bl) {
        super(30);
        this.nodes = expressionArray;
        this.ordinality = bl;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        if (this.isTable) {
            stringBuilder.append("TABLE").append(' ');
        } else {
            stringBuilder.append("UNNEST").append(' ');
        }
        stringBuilder.append(this.nodes[0].describe(session, n));
        return stringBuilder.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        if (this.nodes.length == 1 && this.nodes[0].dataType.isRowType()) {
            if (this.ordinality) {
                throw Error.error(5581, "ORDINALITY");
            }
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.table.prepareTable(session);
            this.table.columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
            this.isTable = true;
            return;
        }
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n].dataType.isArrayType()) continue;
            throw Error.error(5563, "UNNEST");
        }
        n = this.ordinality ? this.nodes.length + 1 : this.nodes.length;
        this.nodeDataTypes = new Type[n];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodeDataTypes[i] = this.nodes[i].dataType.collectionBaseType();
            if (this.nodeDataTypes[i] != null && this.nodeDataTypes[i] != Type.SQL_ALL_TYPES) continue;
            throw Error.error(5567, "UNNEST");
        }
        if (this.ordinality) {
            this.nodeDataTypes[this.nodes.length] = Type.SQL_INTEGER;
        }
        this.table.prepareTable(session);
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.table.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] objectArray = this.table.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        if (this.isTable) {
            this.insertTableValues(session, persistentStore);
        } else {
            this.insertArrayValues(session, persistentStore);
        }
    }

    private void insertTableValues(Session session, PersistentStore persistentStore) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator rowSetNavigator = result.navigator;
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray);
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2, false);
            try {
                persistentStore.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore persistentStore) {
        int n;
        Object[][] objectArrayArray = new Object[this.nodes.length][];
        for (n = 0; n < objectArrayArray.length; ++n) {
            Object[] objectArray = (Object[])this.nodes[n].getValue(session);
            if (objectArray == null) {
                objectArray = ValuePool.emptyObjectArray;
            }
            objectArrayArray[n] = objectArray;
        }
        n = 0;
        while (true) {
            boolean bl = false;
            Object[] objectArray = new Object[this.nodeDataTypes.length];
            for (int i = 0; i < objectArrayArray.length; ++i) {
                if (n >= objectArrayArray[i].length) continue;
                objectArray[i] = objectArrayArray[i][n];
                bl = true;
            }
            if (!bl) break;
            if (this.ordinality) {
                objectArray[this.nodes.length] = ValuePool.getInt(n + 1);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
            try {
                persistentStore.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            ++n;
        }
    }
}

