/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.io.IOException;
import java.util.Map;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.PropertyMap;
import shaded.io.github.spannm.jackcess.expr.EvalException;
import shaded.io.github.spannm.jackcess.impl.ColEvalContext;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.expr.FormatUtil;
import shaded.io.github.spannm.jackcess.util.StringUtil;

public class ColumnFormatter {
    private final ColumnImpl _col;
    private final FormatEvalContext _ctx;
    private String _fmtStr;
    private FormatUtil.StandaloneFormatter _fmt;

    public ColumnFormatter(Column col) throws IOException {
        this._col = (ColumnImpl)col;
        this._ctx = new FormatEvalContext(this._col);
        this.reload();
    }

    public String getFormatString() {
        return this._fmtStr;
    }

    public void setFormatString(String fmtStr) throws IOException {
        PropertyMap props = this._col.getProperties();
        if (!StringUtil.isEmpty(fmtStr)) {
            props.put("Format", fmtStr);
        } else {
            props.remove("Format");
        }
        props.save();
        this.reload();
    }

    public String format(Object val) {
        return this._ctx.format(val);
    }

    public String getRowValue(Object[] rowArray) {
        return this.format(this._col.getRowValue(rowArray));
    }

    public String getRowValue(Map<String, ?> rowMap) {
        return this.format(this._col.getRowValue(rowMap));
    }

    public final void reload() throws IOException {
        this._fmt = null;
        this._fmtStr = null;
        this._fmtStr = (String)this._col.getProperties().getValue("Format");
        this._fmt = FormatUtil.createStandaloneFormatter(this._ctx, this._fmtStr, 1, 1);
    }

    private class FormatEvalContext
    extends ColEvalContext {
        private FormatEvalContext(ColumnImpl col) {
            super(col);
        }

        public String format(Object val) {
            try {
                return ColumnFormatter.this._fmt.format(this.toValue(val)).getAsString(this);
            }
            catch (EvalException ee) {
                return val.toString();
            }
        }
    }
}

