/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Optional;
import net.ucanaccess.complex.Version;
import net.ucanaccess.exception.TableNotFoundException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.triggers.TriggerBase;
import net.ucanaccess.triggers.TriggerException;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.org.hsqldb.types.JavaObjectData;

public class TriggerAppendOnly
extends TriggerBase {
    @Override
    public void fire(int type, String name, String tableName, Object[] oldR, Object[] newR) {
        this.checkContext();
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        if (conn.isFeedbackState()) {
            return;
        }
        try {
            Table t = Optional.ofNullable(this.getTable(tableName, conn)).orElseThrow(() -> new TableNotFoundException(tableName));
            int i = 0;
            for (Column column : t.getColumns()) {
                if (column.isAppendOnly()) {
                    String val;
                    ColumnImpl verCol = (ColumnImpl)column.getVersionHistoryColumn();
                    LocalDateTime upTime = LocalDateTime.now();
                    String string = val = newR[i] == null ? null : newR[i].toString();
                    if (6 == type) {
                        newR[verCol.getColumnNumber()] = new JavaObjectData((Serializable)new Version[]{new Version(val, upTime)});
                    } else if (8 == type && (oldR[i] != null || newR[i] != null) && (oldR[i] == null && newR[i] != null || oldR[i] != null && newR[i] == null || !oldR[i].equals(newR[i]))) {
                        Version[] oldV = (Version[])((JavaObjectData)oldR[verCol.getColumnNumber()]).getObject();
                        Version[] newV = new Version[oldV.length + 1];
                        if (oldV.length > 0) {
                            System.arraycopy(oldV, 0, newV, 1, oldV.length);
                        }
                        newV[0] = new Version(val, upTime);
                        newR[verCol.getColumnNumber()] = new JavaObjectData((Serializable)newV);
                    }
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            throw new TriggerException(_ex.getMessage());
        }
    }
}

