/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.types;

public class TimestampData {
    final long seconds;
    final int nanos;
    final int zone;

    public TimestampData(long l) {
        this.seconds = l;
        this.nanos = 0;
        this.zone = 0;
    }

    public TimestampData(long l, int n) {
        this.seconds = l;
        this.nanos = n;
        this.zone = 0;
    }

    public TimestampData(long l, int n, int n2) {
        this.seconds = l;
        this.nanos = n;
        this.zone = n2;
    }

    public static TimestampData fromMillisecondsGMT(long l) {
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        return new TimestampData(l2, n);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public long getMillis() {
        return this.seconds * 1000L;
    }

    public boolean equals(Object object) {
        if (object instanceof TimestampData) {
            return this.seconds == ((TimestampData)object).seconds && this.nanos == ((TimestampData)object).nanos && this.zone == ((TimestampData)object).zone;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.seconds ^ this.nanos;
    }

    public int compareTo(TimestampData timestampData) {
        long l = this.seconds - timestampData.seconds;
        if (l == 0L && (l = (long)(this.nanos - timestampData.nanos)) == 0L) {
            return 0;
        }
        return l > 0L ? 1 : -1;
    }
}

