/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.persist;

import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.DataFileCache;
import shaded.org.hsqldb.persist.DataFileCacheSession;
import shaded.org.hsqldb.persist.DataSpaceManager;
import shaded.org.hsqldb.persist.DirectoryBlockCachedObject;
import shaded.org.hsqldb.persist.TableSpaceManager;
import shaded.org.hsqldb.persist.TableSpaceManagerBlocks;
import shaded.org.hsqldb.persist.TableSpaceManagerSimple;
import shaded.org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManager defaultSpaceManager;
    final int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    LongLookup lookup;

    DataSpaceManagerSimple(DataFileCache dataFileCache, boolean bl) {
        this.cache = dataFileCache;
        if (dataFileCache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else if (dataFileCache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else {
            int n = dataFileCache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, 4096, n, dataFileCache.getDataFileScale());
            if (!bl) {
                this.initialiseSpaces();
                dataFileCache.spaceManagerPosition = 0L;
            }
        }
        this.totalFragmentSize = dataFileCache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int n) {
        if (n >= this.spaceIdSequence) {
            this.spaceIdSequence = n + 2;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        int n = this.spaceIdSequence;
        this.spaceIdSequence += 2;
        return n;
    }

    @Override
    public long getFileBlocks(int n, int n2) {
        long l = this.cache.getFileFreePos();
        this.cache.enlargeFileSpace(l + (long)n2 * 4096L);
        return l;
    }

    @Override
    public void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
    }

    @Override
    public void freeTableSpace(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n, LongLookup longLookup, long l, long l2) {
        this.totalFragmentSize += longLookup.getTotalValues() * (long)this.cache.getDataFileScale();
        if (this.cache.fileFreePosition == l2) {
            this.cache.writeLock.lock();
            try {
                this.cache.fileFreePosition = l;
            }
            finally {
                this.cache.writeLock.unlock();
            }
        } else {
            this.totalFragmentSize += l2 - l;
        }
        if (longLookup.size() != 0) {
            this.lookup = longLookup.duplicate();
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return 0x100000 * this.cache.getDataFileScale() / 16;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long l = this.cache.getFileFreePos();
        long l2 = (l + 4096L) / 4096L;
        long l3 = this.cache.enlargeFileSpace(l2 * 4096L);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, l3, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues() * (long)this.cache.getDataFileScale();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    @Override
    public int getFileBlockItemCount() {
        return 65536;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        return new DirectoryBlockCachedObject[0];
    }
}

