/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib.java;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class JavaSystem {
    public static final Charset CS_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset CS_US_ASCII = StandardCharsets.US_ASCII;
    public static final Charset CS_UTF8 = StandardCharsets.UTF_8;
    private static int javaVersion;

    public static int javaVersion() {
        return javaVersion;
    }

    public static long availableMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static Throwable unmap(MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer == null) {
            return null;
        }
        if (javaVersion > 8) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Object object = field.get(null);
                Method method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                method.invoke(object, mappedByteBuffer);
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                return invocationTargetException;
            }
            catch (Throwable throwable) {
                return throwable;
            }
        }
        try {
            Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
            Method method2 = object.getClass().getMethod("clean", new Class[0]);
            method2.invoke(object, new Object[0]);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            return invocationTargetException;
        }
        catch (Throwable throwable) {
            return throwable;
        }
        try {
            Method method = mappedByteBuffer.getClass().getMethod("free", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)mappedByteBuffer, new Object[0]);
            return null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    static {
        try {
            String string = System.getProperty("java.version", "6");
            if (string.startsWith("1.")) {
                string = string.substring(2);
            }
            javaVersion = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            javaVersion = 11;
        }
    }
}

