/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.io.Reader;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ScannerSearchAlgorithm {
    public static final int SUGGESTED_MAX_LITERAL_SIZE = 1024;
    private static final Logger LOG = Logger.getLogger(ScannerSearchAlgorithm.class.getName());

    public static long search(Reader reader, char[] cArray, boolean bl) {
        if (reader == null || cArray == null) {
            return -1L;
        }
        if (cArray.length == 0 && bl) {
            return 0L;
        }
        return ScannerSearchAlgorithm.search(reader, new String(cArray), bl);
    }

    public static long search(Reader reader, String string, boolean bl) throws NullPointerException, PatternSyntaxException, IllegalStateException, IllegalArgumentException {
        if (reader == null || string == null) {
            return -1L;
        }
        if (string.length() == 0 && bl) {
            return 0L;
        }
        String string2 = bl ? Pattern.quote(string) : string;
        Pattern pattern = Pattern.compile(string2);
        return ScannerSearchAlgorithm.searchNoChecks(reader, pattern);
    }

    public static long search(Reader reader, Pattern pattern) throws IllegalStateException, IllegalArgumentException {
        if (reader == null || pattern == null) {
            return -1L;
        }
        return ScannerSearchAlgorithm.searchNoChecks(reader, pattern);
    }

    private static long searchNoChecks(Reader reader, Pattern pattern) throws IllegalStateException, IllegalArgumentException {
        Scanner scanner = new Scanner(reader);
        String string = scanner.findWithinHorizon(pattern, 0);
        long l = string == null ? -1L : (long)scanner.match().start();
        return l;
    }

    private ScannerSearchAlgorithm() {
        assert (false) : "Pure Utility Class";
    }
}

