/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import shaded.org.hsqldb.lib.AbstractReadOnlyCollection;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.Map;
import shaded.org.hsqldb.lib.MapEntry;
import shaded.org.hsqldb.lib.PrimitiveIterator;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.map.BaseHashMap;

public class IntKeyIntValueHashMap
extends BaseHashMap
implements Map<Integer, Integer> {
    private Set<Integer> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Integer, Integer>> entries;

    public IntKeyIntValueHashMap() {
        this(8);
    }

    public IntKeyIntValueHashMap(int n) throws IllegalArgumentException {
        super(n, 1, 1, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsIntKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsKey(int n) {
        return super.containsIntKey(n);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsValue(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n) {
        return super.containsValue(n);
    }

    @Override
    public Integer get(Integer n) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            int n4 = this.intValueTable[n3];
            return n4;
        }
        return null;
    }

    @Override
    public int get(int n) throws NoSuchElementException {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public int get(int n, int n2) {
        int n3 = this.getLookup(n);
        if (n3 != -1) {
            return this.intValueTable[n3];
        }
        return n2;
    }

    public boolean get(int n, int[] nArray) {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            nArray[0] = this.intValueTable[n2];
            return true;
        }
        return false;
    }

    @Override
    public Integer put(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            throw new NullPointerException();
        }
        int n3 = this.size();
        super.addOrUpdate(n.intValue(), n2.intValue(), null, null);
        if (n3 == this.size()) {
            return null;
        }
        return n2;
    }

    @Override
    public boolean put(int n, int n2) {
        int n3 = this.size();
        super.addOrUpdate(n, n2, null, null);
        return n3 != this.size();
    }

    @Override
    public Integer remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return (Integer)super.remove(n, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int n) {
        Integer n2 = (Integer)super.remove(n, 0L, null, null, false, false);
        return n2 != null;
    }

    public void putAll(IntKeyIntValueHashMap intKeyIntValueHashMap) {
        Iterator iterator = intKeyIntValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.nextInt();
            int n2 = intKeyIntValueHashMap.get(n);
            this.put(n, n2);
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public int[] valuesToArray(int[] nArray) {
        return this.toIntArray(nArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            Objects.requireNonNull(intKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            Objects.requireNonNull(intKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            Integer n = super.nextInt();
            Integer n2 = IntKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Integer, Integer>(n, n2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Integer>>
    implements Set<Map.Entry<Integer, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

