/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import shaded.org.hsqldb.lib.AbstractReadOnlyCollection;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.IntKeyHashMap;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.Map;
import shaded.org.hsqldb.lib.MapEntry;
import shaded.org.hsqldb.lib.PrimitiveIterator;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.map.BaseHashMap;

public class IntKeyHashMapConcurrent<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public IntKeyHashMapConcurrent() {
        this(8);
    }

    public IntKeyHashMapConcurrent(int n) throws IllegalArgumentException {
        super(n, 1, 3, false);
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsIntKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsKey(int n) {
        try {
            this.readLock.lock();
            boolean bl = super.containsIntKey(n);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        try {
            this.readLock.lock();
            boolean bl = super.containsValue(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Integer n) {
        if (n instanceof Integer) {
            int n2 = n;
            return this.get(n2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(int n) {
        try {
            this.readLock.lock();
            int n2 = this.getLookup(n);
            if (n2 != -1) {
                Object object = this.objectValueTable[n2];
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(Integer n, V v) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.put(n2, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(int n, V v) {
        try {
            this.writeLock.lock();
            Object object = super.addOrUpdate(n, 0L, null, v);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.remove(n);
        }
        return null;
    }

    public V remove(int n) {
        try {
            this.writeLock.lock();
            Object object = super.remove(n, 0L, null, null, false, false);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(IntKeyHashMap<V> intKeyHashMap) {
        try {
            this.writeLock.lock();
            Iterator iterator = intKeyHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = iterator.nextInt();
                this.put(n, intKeyHashMap.get(n));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrderedKeyMatchCount(int[] nArray) {
        try {
            int n;
            this.readLock.lock();
            for (n = 0; n < nArray.length && super.containsIntKey(nArray[n]); ++n) {
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int[] keysToArray(int[] nArray) {
        try {
            this.readLock.lock();
            int[] nArray2 = this.toIntArray(nArray, true);
            return nArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T[] valuesToArray(T[] TArray) {
        try {
            this.readLock.lock();
            T[] TArray2 = this.toArray(TArray, false);
            return TArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            Objects.requireNonNull(intKeyHashMapConcurrent);
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, false);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            Objects.requireNonNull(intKeyHashMapConcurrent);
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, true);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMapConcurrent.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer n = super.nextInt();
            Object object = IntKeyHashMapConcurrent.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(n, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

