/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.index;

import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.RowAVL;
import shaded.org.hsqldb.index.Index;
import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.CachedObject;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class NodeAVL
implements CachedObject {
    static final int NO_POS = -1;
    public int iBalance;
    public NodeAVL nNext;
    protected NodeAVL nLeft;
    protected NodeAVL nRight;
    protected NodeAVL nParent;
    protected final Row row;

    NodeAVL() {
        this.row = null;
    }

    public NodeAVL(Row row) {
        this.row = row;
    }

    public void delete() {
        this.iBalance = 0;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    NodeAVL getLeft(PersistentStore persistentStore) {
        return this.nLeft;
    }

    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL nodeAVL) {
        this.nLeft = nodeAVL;
        return this;
    }

    public int getBalance(PersistentStore persistentStore) {
        return this.iBalance;
    }

    boolean isLeft(PersistentStore persistentStore, NodeAVL nodeAVL) {
        return this.nLeft == nodeAVL;
    }

    boolean isRight(PersistentStore persistentStore, NodeAVL nodeAVL) {
        return this.nRight == nodeAVL;
    }

    NodeAVL getRight(PersistentStore persistentStore) {
        return this.nRight;
    }

    NodeAVL setRight(PersistentStore persistentStore, NodeAVL nodeAVL) {
        this.nRight = nodeAVL;
        return this;
    }

    NodeAVL getParent(PersistentStore persistentStore) {
        return this.nParent;
    }

    boolean isRoot(PersistentStore persistentStore) {
        return this.nParent == null;
    }

    NodeAVL setParent(PersistentStore persistentStore, NodeAVL nodeAVL) {
        this.nParent = nodeAVL;
        return this;
    }

    public NodeAVL setBalance(PersistentStore persistentStore, int n) {
        this.iBalance = n;
        return this;
    }

    boolean isFromLeft(PersistentStore persistentStore) {
        if (this.nParent == null) {
            return true;
        }
        return this == this.nParent.nLeft;
    }

    public NodeAVL child(PersistentStore persistentStore, boolean bl) {
        return bl ? this.getLeft(persistentStore) : this.getRight(persistentStore);
    }

    public NodeAVL set(PersistentStore persistentStore, boolean bl, NodeAVL nodeAVL) {
        if (bl) {
            this.nLeft = nodeAVL;
        } else {
            this.nRight = nodeAVL;
        }
        if (nodeAVL != null) {
            nodeAVL.nParent = this;
        }
        return this;
    }

    public void replace(PersistentStore persistentStore, Index index, NodeAVL nodeAVL) {
        if (this.nParent == null) {
            if (nodeAVL != null) {
                nodeAVL = nodeAVL.setParent(persistentStore, null);
            }
            persistentStore.setAccessor(index, nodeAVL);
        } else {
            this.nParent.set(persistentStore, this.isFromLeft(persistentStore), nodeAVL);
        }
    }

    boolean equals(NodeAVL nodeAVL) {
        return nodeAVL == this;
    }

    @Override
    public void setInMemory(boolean bl) {
    }

    @Override
    public int getDefaultCapacity() {
        return 0;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
    }

    @Override
    public long getPos() {
        return 0L;
    }

    public RowAVL getRow(PersistentStore persistentStore) {
        return (RowAVL)this.row;
    }

    protected Object[] getData(PersistentStore persistentStore) {
        return this.row.getData();
    }

    @Override
    public void updateAccessCount(int n) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public final boolean isInvariable() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return false;
    }

    @Override
    public void setPos(long l) {
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean bl) {
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean bl) {
        return true;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 0;
    }

    @Override
    public boolean isMemory() {
        return true;
    }
}

