/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.index;

import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.RowAVL;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableBase;
import shaded.org.hsqldb.index.Index;
import shaded.org.hsqldb.index.IndexAVL;
import shaded.org.hsqldb.index.IndexStats;
import shaded.org.hsqldb.index.NodeAVL;
import shaded.org.hsqldb.index.NodeAVLDisk;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.IntKeyHashMap;
import shaded.org.hsqldb.lib.OrderedLongHashSet;
import shaded.org.hsqldb.map.BitMap;
import shaded.org.hsqldb.persist.DataFileCache;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.persist.RowStoreAVL;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.rowio.RowInputBinary;

public class IndexAVLCheck {
    public static Result checkAllTables(Session session, int n) {
        Result result = IndexStats.newEmptyResult();
        HsqlArrayList<Table> hsqlArrayList = session.database.schemaManager.getAllTables(true);
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            Table table = hsqlArrayList.get(i);
            if (!table.isCached()) continue;
            IndexAVLCheck.checkTable(session, table, result, n);
        }
        return result;
    }

    public static Result checkTable(Session session, Table table, int n) {
        Result result = IndexStats.newEmptyResult();
        if (!table.isCached()) {
            return result;
        }
        IndexAVLCheck.checkTable(session, table, result, n);
        return result;
    }

    public static void checkTable(Session session, Table table, Result result, int n) {
        int n2;
        RowStoreAVL rowStoreAVL = (RowStoreAVL)table.database.persistentStoreCollection.getStore(table);
        IndexStats[] indexStatsArray = rowStoreAVL.checkIndexes(session, n);
        indexStatsArray[0].addTableStats(result);
        for (n2 = 0; n2 < indexStatsArray.length; ++n2) {
            indexStatsArray[n2].addStats(result);
        }
        if (n == 8) {
            int n3;
            n2 = 0;
            for (n3 = 0; n3 < indexStatsArray.length; ++n3) {
                if (!indexStatsArray[n3].hasErrors) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) {
                IndexAVLCheck.reindexTable(session, table, rowStoreAVL, indexStatsArray);
                for (n3 = 0; n3 < indexStatsArray.length; ++n3) {
                    if (!indexStatsArray[n3].reindexed) continue;
                    indexStatsArray[n3].addReindexedStats(result);
                }
            }
        }
    }

    public static void reindexTable(Session session, Table table, PersistentStore persistentStore, IndexStats[] indexStatsArray) {
        int n;
        Index index = null;
        boolean bl = false;
        for (n = 0; n < indexStatsArray.length; ++n) {
            if (indexStatsArray[n].hasErrors) continue;
            index = table.getIndex(n);
            break;
        }
        if (index == null) {
            session.database.logger.logSevereEvent("could not recreate damaged indexes for table: " + table.getName().statementName, null);
            return;
        }
        for (n = 0; n < indexStatsArray.length; ++n) {
            if (!indexStatsArray[n].hasErrors) continue;
            Index index2 = table.getIndex(n);
            persistentStore.reindex(session, index2, index);
            indexStatsArray[n].reindexed = true;
            bl = true;
        }
        if (bl) {
            session.database.logger.logSevereEvent("recreated damaged indexes for table: " + table.getName().statementName, null);
        }
    }

    public static class IndexAVLProbe {
        static final int maxDepth = 16;
        final int fileBlockItemCount;
        final int cacheScale;
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        final NodeAVLDisk rootNode;
        IntKeyHashMap<BitMap> bitMaps;
        IntKeyHashMap<BitMap> bitMapsPos;
        OrderedLongHashSet badRows;
        OrderedLongHashSet loopedRows;
        OrderedLongHashSet ignoreRows;
        HsqlArrayList<String> unorderedRows = new HsqlArrayList();
        int branchPosition;
        int leafPosition;
        long errorRowCount;
        long rowCount;
        long loopCount;
        boolean printErrors = false;

        public IndexAVLProbe(Session session, PersistentStore persistentStore, IndexAVL indexAVL, NodeAVL nodeAVL) {
            DataFileCache dataFileCache = persistentStore.getCache();
            this.fileBlockItemCount = dataFileCache == null ? 0 : persistentStore.getCache().spaceManager.getFileBlockItemCount();
            this.cacheScale = dataFileCache == null ? 0 : persistentStore.getCache().getDataFileScale();
            this.session = session;
            this.store = persistentStore;
            this.index = indexAVL;
            this.rootNode = dataFileCache == null ? null : (NodeAVLDisk)nodeAVL;
        }

        public IndexStats getStats() {
            IndexStats indexStats = new IndexStats();
            indexStats.index = this.index;
            indexStats.store = this.store;
            indexStats.errorCount = this.errorRowCount;
            indexStats.loopCount = this.loopCount;
            indexStats.goodRowCount = this.rowCount;
            indexStats.unorderedList = this.unorderedRows;
            indexStats.hasErrors = this.hasErrors();
            return indexStats;
        }

        public boolean hasErrors() {
            return this.errorRowCount != 0L || this.loopCount != 0L || !this.unorderedRows.isEmpty();
        }

        public void probe() {
            if (this.index == null) {
                return;
            }
            if (this.rootNode == null) {
                return;
            }
            if (this.fileBlockItemCount == 0) {
                return;
            }
            this.bitMaps = new IntKeyHashMap();
            this.bitMapsPos = new IntKeyHashMap();
            this.badRows = new OrderedLongHashSet();
            this.loopedRows = new OrderedLongHashSet();
            this.ignoreRows = new OrderedLongHashSet();
            this.unorderedRows = new HsqlArrayList();
            RowAVL rowAVL = this.rootNode.getRow(this.store);
            this.setSpaceForRow(rowAVL);
            this.getNodesFrom(0, this.rootNode, true);
            if (!this.hasErrors()) {
                this.checkIndexOrder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkIndexOrder() {
            int n = 0;
            this.store.readLock();
            try {
                NodeAVL nodeAVL;
                NodeAVL nodeAVL2 = null;
                for (nodeAVL = this.index.getAccessor(this.store); nodeAVL != null; nodeAVL = nodeAVL.getLeft(this.store)) {
                    nodeAVL2 = nodeAVL;
                }
                nodeAVL = nodeAVL2;
                while (nodeAVL2 != null) {
                    int n2;
                    n += this.checkNodes(nodeAVL2, this.unorderedRows);
                    NodeAVL nodeAVL3 = this.index.next(this.store, nodeAVL2);
                    if (nodeAVL3 != null && (n2 = this.index.compareRowForInsertOrDelete(this.session, nodeAVL3.getRow(this.store), nodeAVL2.getRow(this.store), true, 0)) <= 0) {
                        if (n < 10) {
                            this.unorderedRows.add("broken index order ");
                        }
                        ++n;
                    }
                    nodeAVL2 = nodeAVL3;
                }
            }
            finally {
                this.store.readUnlock();
            }
        }

        int checkNodes(NodeAVL nodeAVL, HsqlArrayList<String> hsqlArrayList) {
            NodeAVLDisk nodeAVLDisk = (NodeAVLDisk)nodeAVL.getLeft(this.store);
            NodeAVLDisk nodeAVLDisk2 = (NodeAVLDisk)nodeAVL.getRight(this.store);
            int n = 0;
            if (nodeAVLDisk != null && nodeAVLDisk.iBalance == -2) {
                hsqlArrayList.add("broken index - deleted");
                ++n;
            }
            if (nodeAVLDisk2 != null && nodeAVLDisk2.iBalance == -2) {
                hsqlArrayList.add("broken index -deleted");
                ++n;
            }
            if (nodeAVLDisk != null && nodeAVL.getPos() != nodeAVLDisk.getParentPos()) {
                hsqlArrayList.add("broken index - no parent");
                ++n;
            }
            if (nodeAVLDisk2 != null && nodeAVL.getPos() != nodeAVLDisk2.getParentPos()) {
                hsqlArrayList.add("broken index - no parent");
                ++n;
            }
            return n;
        }

        public TableBase getCurrentTable() {
            return this.index.getTable();
        }

        public long getErrorCount() {
            return this.errorRowCount;
        }

        public IntKeyHashMap<BitMap> getBitMaps() {
            return this.bitMaps;
        }

        public OrderedLongHashSet getBadRowPosList() {
            return this.badRows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNodesFrom(int n, NodeAVLDisk nodeAVLDisk, boolean bl) {
            NodeAVLDisk nodeAVLDisk2;
            if (nodeAVLDisk == null) {
                return;
            }
            long l = nodeAVLDisk.getPos();
            if (!this.recordRowPos(l)) {
                this.loopedRows.add(l);
                return;
            }
            ++this.rowCount;
            if (!bl) {
                this.ignoreRows.add(l);
            }
            long l2 = nodeAVLDisk.getLeftPos();
            try {
                if (this.badRows.contains(l2)) {
                    return;
                }
                NodeAVLDisk nodeAVLDisk3 = (NodeAVLDisk)nodeAVLDisk.getLeft(this.store);
                if (nodeAVLDisk3 != null) {
                    RowAVL rowAVL = nodeAVLDisk3.getRow(this.store);
                    if (this.setSpaceForRow(rowAVL)) {
                        this.getNodesFrom(n + 1, nodeAVLDisk3, true);
                        if (nodeAVLDisk3.getParentPos() != l) {
                            nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(l2);
                    }
                }
            }
            catch (HsqlException hsqlException) {
                RowInputBinary rowInputBinary = (RowInputBinary)hsqlException.info;
                if (rowInputBinary != null) {
                    rowInputBinary.ignoreDataErrors = true;
                    try {
                        nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getLeft(this.store);
                        this.getNodesFrom(n + 1, nodeAVLDisk2, false);
                    }
                    catch (Throwable throwable) {
                        this.badRows.add((int)l2);
                    }
                    finally {
                        rowInputBinary.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable throwable) {
                ++this.errorRowCount;
            }
            long l3 = nodeAVLDisk.getRightPos();
            try {
                if (this.badRows.contains(l3)) {
                    return;
                }
                nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getRight(this.store);
                if (nodeAVLDisk2 != null) {
                    RowAVL rowAVL = nodeAVLDisk2.getRow(this.store);
                    if (this.setSpaceForRow(rowAVL)) {
                        this.getNodesFrom(n + 1, nodeAVLDisk2, true);
                        if (nodeAVLDisk2.getParentPos() != l) {
                            NodeAVLDisk nodeAVLDisk4 = (NodeAVLDisk)nodeAVLDisk.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(l3);
                    }
                }
            }
            catch (HsqlException hsqlException) {
                RowInputBinary rowInputBinary = (RowInputBinary)hsqlException.info;
                if (rowInputBinary != null) {
                    rowInputBinary.ignoreDataErrors = true;
                    try {
                        NodeAVLDisk nodeAVLDisk5 = (NodeAVLDisk)nodeAVLDisk.getRight(this.store);
                        this.getNodesFrom(n + 1, nodeAVLDisk5, false);
                    }
                    catch (Throwable throwable) {
                        this.badRows.add(l3);
                    }
                    finally {
                        rowInputBinary.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable throwable) {
                ++this.errorRowCount;
            }
        }

        boolean setSpaceForRow(Row row) {
            long l = row.getPos();
            int n = row.getStorageSize() / this.cacheScale;
            boolean bl = true;
            while (n > 0) {
                BitMap bitMap;
                int n2;
                int n3 = (int)(l / (long)this.fileBlockItemCount);
                int n4 = (int)(l % (long)this.fileBlockItemCount);
                int n5 = this.fileBlockItemCount - n4;
                if (n5 > n) {
                    n5 = n;
                }
                if ((n2 = (bitMap = this.getBitMap(n3)).countSetBits(n4, n4 + n5)) > 0) {
                    if (this.printErrors) {
                        System.out.println("index scan - row duplicate in file block " + n3 + " offset " + n4);
                    }
                    bl = false;
                } else {
                    bitMap.setRange(n4, n5);
                }
                n -= n5;
                l += (long)n5;
            }
            return bl;
        }

        BitMap getBitMap(int n) {
            BitMap bitMap = this.bitMaps.get(n);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMaps.put(n, bitMap);
            }
            return bitMap;
        }

        boolean recordRowPos(long l) {
            int n = (int)(l / (long)this.fileBlockItemCount);
            int n2 = (int)(l % (long)this.fileBlockItemCount);
            BitMap bitMap = this.getPosSet(n);
            if (bitMap.isSet(n2)) {
                return false;
            }
            bitMap.set(n2);
            return true;
        }

        BitMap getPosSet(int n) {
            BitMap bitMap = this.bitMapsPos.get(n);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMapsPos.put(n, bitMap);
            }
            return bitMap;
        }
    }
}

