/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Statement;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.OrderedIntHashSet;
import shaded.org.hsqldb.result.Result;

public class StatementHandler
extends Statement {
    public static final int NONE = 0;
    public static final int SQL_EXCEPTION = 1;
    public static final int SQL_WARNING = 2;
    public static final int SQL_NOT_FOUND = 3;
    public static final int SQL_STATE = 4;
    public static final int CONTINUE = 5;
    public static final int EXIT = 6;
    public static final int UNDO = 7;
    public final int handlerType;
    private OrderedIntHashSet conditionGroups = new OrderedIntHashSet();
    private OrderedHashSet<String> conditionStates = new OrderedHashSet();
    private Statement statement;
    public static final StatementHandler[] emptyExceptionHandlerArray = new StatementHandler[0];

    StatementHandler(int n) {
        super(1212, 2007);
        this.handlerType = n;
    }

    public void addConditionState(String string) {
        boolean bl = this.conditionStates.add(string);
        if (!(bl &= this.conditionGroups.isEmpty())) {
            throw Error.error(5612);
        }
    }

    public void addConditionType(int n) {
        boolean bl = this.conditionGroups.add(n);
        if (!(bl &= this.conditionStates.isEmpty())) {
            throw Error.error(5612);
        }
    }

    public void addStatement(Statement statement) {
        this.statement = statement;
    }

    public boolean handlesConditionType(int n) {
        return this.conditionGroups.contains(n);
    }

    public boolean handlesCondition(String string) {
        if (this.conditionStates.contains(string)) {
            return true;
        }
        String string2 = string.substring(0, 2);
        if (this.conditionStates.contains(string2)) {
            return true;
        }
        if (string2.equals("01")) {
            return this.conditionGroups.contains(2);
        }
        if (string2.equals("02")) {
            return this.conditionGroups.contains(3);
        }
        return this.conditionGroups.contains(1);
    }

    public int[] getConditionTypes() {
        return this.conditionGroups.toArray();
    }

    public String[] getConditionStates() {
        String[] stringArray = new String[this.conditionStates.size()];
        this.conditionStates.toArray(stringArray);
        return stringArray;
    }

    @Override
    public void resolve(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.readTableNames = this.statement.getTableNamesForRead();
            this.writeTableNames = this.statement.getTableNamesForWrite();
        }
    }

    @Override
    public Result execute(Session session) {
        if (this.statement != null) {
            return this.statement.execute(session);
        }
        return Result.updateZeroResult;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        if (this.statement == null) {
            return new OrderedHashSet<HsqlNameManager.HsqlName>();
        }
        return this.statement.getReferences();
    }

    @Override
    public String getSQL() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = this.handlerType == 5 ? "CONTINUE" : (this.handlerType == 6 ? "EXIT" : "UNDO");
        stringBuilder.append("DECLARE").append(' ').append(string).append(' ').append("HANDLER").append(' ').append("FOR").append(' ');
        for (n = 0; n < this.conditionStates.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("SQLSTATE").append(' ').append('\'').append(this.conditionStates.get(n)).append('\'');
        }
        block6: for (n = 0; n < this.conditionGroups.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            switch (this.conditionGroups.get(n)) {
                case 1: {
                    stringBuilder.append("SQLEXCEPTION");
                    continue block6;
                }
                case 2: {
                    stringBuilder.append("SQLWARNING");
                    continue block6;
                }
                case 3: {
                    stringBuilder.append("NOT").append(' ').append(484);
                }
            }
        }
        if (this.statement != null) {
            stringBuilder.append(' ').append(this.statement.getSQL());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

