/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.Constraint;
import shaded.org.hsqldb.ExpressionColumn;
import shaded.org.hsqldb.GroupSet;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Statement;
import shaded.org.hsqldb.StatementDMQL;
import shaded.org.hsqldb.StatementResultUpdate;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.HashSet;
import shaded.org.hsqldb.lib.HsqlDeque;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.LongDeque;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.navigator.RangeIterator;
import shaded.org.hsqldb.navigator.RowSetNavigatorDataChange;
import shaded.org.hsqldb.navigator.RowSetNavigatorDataChangeMemory;
import shaded.org.hsqldb.result.Result;

public class SessionContext {
    Session session;
    public boolean isAutoCommit;
    boolean isReadOnly;
    boolean noSQL;
    int autoCommitRows;
    int currentMaxRows;
    OrderedHashMap<String, ColumnSchema> sessionVariables;
    RangeVariable[] sessionVariablesRange;
    RangeGroup[] sessionVariableRangeGroups;
    private HsqlDeque<Object> stack;
    Object[] diagnosticsVariables = ValuePool.emptyObjectArray;
    Object[] routineArguments = ValuePool.emptyObjectArray;
    Object[] routineVariables = ValuePool.emptyObjectArray;
    Result[] routineCursors = Result.emptyArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    Object[][] triggerArguments = null;
    public int depth;
    boolean isInRoutine;
    Number lastIdentity = ValuePool.INTEGER_0;
    OrderedHashMap<String, Integer> savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    GroupSet groupSet;
    List currentGroup;
    OrderedHashMap<String, Table> sessionTables;
    OrderedHashMap<String, Table> popSessionTables;
    public volatile Statement currentStatement;
    public volatile boolean invalidStatement;
    public int rownum;
    HashSet<Constraint> constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();
    RangeIterator checkIterator = new RangeVariable.RangeIteratorCheck();

    SessionContext(Session session) {
        this.session = session;
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new OrderedHashMap();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, null, true, 4);
        this.sessionVariableRangeGroups = new RangeGroup[]{new RangeGroup.RangeGroupSimple(this.sessionVariablesRange, true)};
        this.isAutoCommit = false;
        this.isReadOnly = false;
        this.noSQL = false;
        this.isInRoutine = false;
    }

    void resetStack() {
        while (this.depth > 0) {
            this.pop(this.isInRoutine);
        }
    }

    public void push() {
        this.push(false);
    }

    private void push(boolean bl) {
        if (this.depth > 256) {
            throw Error.error(3474);
        }
        this.session.sessionData.persistentStoreCollection.push(bl);
        if (this.stack == null) {
            this.stack = new HsqlDeque();
        }
        this.stack.add(this.diagnosticsVariables);
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.triggerArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.routineCursors);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.lastIdentity);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(this.isInRoutine);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.stack.add(ValuePool.getInt(this.rownum));
        this.stack.add(this.currentStatement);
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = false;
        this.currentMaxRows = 0;
        this.isInRoutine = bl;
        ++this.depth;
    }

    public void pop() {
        this.pop(false);
    }

    private void pop(boolean bl) {
        this.session.sessionData.persistentStoreCollection.pop(bl);
        this.currentStatement = (Statement)this.stack.removeLast();
        this.rownum = (Integer)this.stack.removeLast();
        this.currentMaxRows = (Integer)this.stack.removeLast();
        this.isInRoutine = (Boolean)this.stack.removeLast();
        this.noSQL = (Boolean)this.stack.removeLast();
        this.isReadOnly = (Boolean)this.stack.removeLast();
        this.isAutoCommit = (Boolean)this.stack.removeLast();
        this.lastIdentity = (Number)this.stack.removeLast();
        this.savepointTimestamps = (LongDeque)this.stack.removeLast();
        this.savepoints = (OrderedHashMap)this.stack.removeLast();
        this.rangeIterators = (RangeIterator[])this.stack.removeLast();
        this.routineCursors = (Result[])this.stack.removeLast();
        this.routineVariables = (Object[])this.stack.removeLast();
        this.triggerArguments = (Object[][])this.stack.removeLast();
        this.routineArguments = (Object[])this.stack.removeLast();
        this.dynamicArguments = (Object[])this.stack.removeLast();
        this.diagnosticsVariables = (Object[])this.stack.removeLast();
        --this.depth;
    }

    public void pushRoutineInvocation() {
        this.push(true);
    }

    public void popRoutineInvocation() {
        this.pop(true);
    }

    public void pushDynamicArguments(Object[] objectArray) {
        this.push();
        this.dynamicArguments = objectArray;
    }

    public void pushStatementState() {
        if (this.stack == null) {
            this.stack = new HsqlDeque();
        }
        this.stack.addLast(ValuePool.getInt(this.rownum));
    }

    public void popStatementState() {
        this.rownum = (Integer)this.stack.removeLast();
    }

    public void setDynamicArguments(Object[] objectArray) {
        this.dynamicArguments = objectArray;
    }

    RowSetNavigatorDataChange getRowSetDataChange() {
        return new RowSetNavigatorDataChangeMemory(this.session);
    }

    void clearStructures(StatementDMQL statementDMQL) {
        int n = statementDMQL.rangeIteratorCount;
        if (n > this.rangeIterators.length) {
            n = this.rangeIterators.length;
        }
        for (int i = 0; i < n; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].release();
            this.rangeIterators[i] = null;
        }
    }

    public RangeIterator getCheckIterator(RangeVariable rangeVariable) {
        int n = rangeVariable.rangePosition;
        if (n >= this.rangeIterators.length) {
            int n2 = (int)ArrayUtil.getBinaryNormalisedCeiling(n + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, n2);
        }
        this.rangeIterators[n] = this.checkIterator;
        return this.checkIterator;
    }

    public void setRangeIterator(RangeIterator rangeIterator) {
        int n = rangeIterator.getRangePosition();
        if (n >= this.rangeIterators.length) {
            int n2 = (int)ArrayUtil.getBinaryNormalisedCeiling(n + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, n2);
        }
        this.rangeIterators[n] = rangeIterator;
    }

    public RangeIterator getRangeIterator(int n) {
        RangeIterator[] rangeIteratorArray = this.rangeIterators;
        if (this.stack != null) {
            for (int i = 0; i < this.stack.size(); ++i) {
                Object object = this.stack.get(i);
                if (!(object instanceof RangeIterator[])) continue;
                rangeIteratorArray = (RangeIterator[])object;
                break;
            }
        }
        return rangeIteratorArray[n];
    }

    public void unsetRangeIterator(RangeIterator rangeIterator) {
        int n = rangeIterator.getRangePosition();
        this.rangeIterators[n] = null;
    }

    public void setGroupSet(GroupSet groupSet) {
        this.groupSet = groupSet;
    }

    public void setGroup(List list) {
        this.currentGroup = list;
    }

    public HashSet<Constraint> getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema columnSchema) {
        int n = this.sessionVariables.size();
        if (!this.sessionVariables.add(columnSchema.getName().name, columnSchema)) {
            throw Error.error(5504);
        }
        Object[] objectArray = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, objectArray, this.routineVariables.length);
        this.routineVariables = objectArray;
        this.routineVariables[n] = columnSchema.getDefaultValue(this.session);
    }

    public void pushRoutineTables() {
        this.popSessionTables = this.sessionTables;
        this.sessionTables = new OrderedHashMap();
    }

    public void popRoutineTables() {
        this.sessionTables.clear();
        this.sessionTables = this.popSessionTables;
    }

    public void addSessionTable(Table table) {
        if (this.sessionTables == null) {
            this.sessionTables = new OrderedHashMap();
        }
        if (this.sessionTables.containsKey(table.getName().name)) {
            throw Error.error(5504);
        }
        this.sessionTables.add(table.getName().name, table);
    }

    public void setSessionTables(Table[] tableArray) {
    }

    public Table findSessionTable(String string) {
        if (this.sessionTables == null) {
            return null;
        }
        return (Table)this.sessionTables.get((Object)string);
    }

    public void dropSessionTable(String string) {
        this.sessionTables.remove(string);
    }
}

