/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.expr;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import shaded.io.github.spannm.jackcess.impl.expr.FormatUtil;
import shaded.io.github.spannm.jackcess.impl.expr.NumberFormatter;

public class NumericConfig {
    public static final NumericConfig US_NUMERIC_CONFIG = new NumericConfig(2, true, false, true, 3, Locale.US);
    private final int _numDecDigits;
    private final boolean _incLeadingDigit;
    private final boolean _useNegParens;
    private final boolean _useNegCurrencyParens;
    private final int _numGroupDigits;
    private final DecimalFormatSymbols _symbols;
    private final NumberFormatter _numFmt;
    private final String _currencyFormat;
    private final String _fixedFormat;
    private final String _standardFormat;
    private final String _percentFormat;
    private final String _scientificFormat;
    private final String _euroFormat;

    public NumericConfig(int numDecDigits, boolean incLeadingDigit, boolean useNegParens, boolean useNegCurrencyParens, int numGroupDigits, Locale locale) {
        this._numDecDigits = numDecDigits;
        this._incLeadingDigit = incLeadingDigit;
        this._useNegParens = useNegParens;
        this._useNegCurrencyParens = useNegCurrencyParens;
        this._numGroupDigits = numGroupDigits;
        this._symbols = DecimalFormatSymbols.getInstance(locale);
        this._numFmt = new NumberFormatter(this._symbols);
        this._currencyFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.CURRENCY, this._numDecDigits, this._incLeadingDigit, this._useNegCurrencyParens, this._numGroupDigits);
        this._fixedFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.GENERAL, this._numDecDigits, true, this._useNegParens, 0);
        this._standardFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.GENERAL, this._numDecDigits, this._incLeadingDigit, this._useNegParens, this._numGroupDigits);
        this._percentFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.PERCENT, this._numDecDigits, this._incLeadingDigit, this._useNegParens, 0);
        this._scientificFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.SCIENTIFIC, this._numDecDigits, true, false, 0);
        this._euroFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.EURO, this._numDecDigits, this._incLeadingDigit, this._useNegCurrencyParens, this._numGroupDigits);
    }

    public int getNumDecimalDigits() {
        return this._numDecDigits;
    }

    public boolean includeLeadingDigit() {
        return this._incLeadingDigit;
    }

    public boolean useParensForNegatives() {
        return this._useNegParens;
    }

    public boolean useParensForCurrencyNegatives() {
        return this._useNegCurrencyParens;
    }

    public int getNumGroupingDigits() {
        return this._numGroupDigits;
    }

    public String getNumberFormat(Type type) {
        switch (type) {
            case CURRENCY: {
                return this._currencyFormat;
            }
            case FIXED: {
                return this._fixedFormat;
            }
            case STANDARD: {
                return this._standardFormat;
            }
            case PERCENT: {
                return this._percentFormat;
            }
            case SCIENTIFIC: {
                return this._scientificFormat;
            }
            case EURO: {
                return this._euroFormat;
            }
        }
        throw new IllegalArgumentException("unknown number type " + type);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this._symbols;
    }

    public String format(float f) {
        return this._numFmt.format(f);
    }

    public String format(double d) {
        return this._numFmt.format(d);
    }

    public String format(BigDecimal bd) {
        return this._numFmt.format(bd);
    }

    public static enum Type {
        CURRENCY,
        FIXED,
        STANDARD,
        PERCENT,
        SCIENTIFIC,
        EURO;

    }
}

