/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.console;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Exporter {
    private static final String DEFAULT_CSV_DELIMITER = ";";
    private static final String QUOTE = "\"";
    private static final byte[] UTF8_BYTE_ORDER_MARK = new byte[]{-17, -69, -65};
    private final String delimiter;
    private final boolean includeBom;
    private final boolean preserveNewlines;

    private Exporter(String _delimter, boolean _includeBom, boolean _preserveNewlines) {
        this.delimiter = _delimter;
        this.includeBom = _includeBom;
        this.preserveNewlines = _preserveNewlines;
    }

    public void dumpCsv(ResultSet _rs, PrintStream _out) throws SQLException, IOException {
        if (this.includeBom) {
            _out.write(UTF8_BYTE_ORDER_MARK);
        }
        ResultSetMetaData meta = _rs.getMetaData();
        int cols = meta.getColumnCount();
        String comma = "";
        for (int i = 1; i <= cols; ++i) {
            _out.print(comma);
            _out.print(Exporter.toCsv(meta.getColumnLabel(i), this.delimiter, this.preserveNewlines));
            comma = this.delimiter;
        }
        _out.println();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DecimalFormat decimalFormat = new DecimalFormat("0.0########");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(dfs);
        decimalFormat.setGroupingUsed(false);
        while (_rs.next()) {
            comma = "";
            for (int i = 1; i <= cols; ++i) {
                Object o = _rs.getObject(i);
                String str = o == null ? "(null)" : (o.getClass().isArray() ? Arrays.toString((Object[])o) : (o instanceof Date ? dateFormat.format((Date)o) : (o instanceof BigDecimal ? decimalFormat.format(o) : o.toString())));
                _out.print(comma);
                _out.print(Exporter.toCsv(str, this.delimiter, this.preserveNewlines));
                comma = this.delimiter;
            }
            _out.println();
        }
    }

    public void dumpSchema(ResultSet _rs, PrintStream _out) throws SQLException {
        ResultSetMetaData meta = _rs.getMetaData();
        int cols = meta.getColumnCount();
        _out.println('[');
        for (int i = 1; i <= cols; ++i) {
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            int nullable = meta.isNullable(i);
            _out.print(Exporter.toSchemaRow(name, sqlType, nullable));
            _out.printf(i != cols ? ",%n" : "%n", new Object[0]);
        }
        _out.println(']');
    }

    static String toCsv(String _str, String _delimiter, boolean _preserveNewlines) {
        boolean needsTextQualifier = false;
        if (_str.contains(QUOTE)) {
            _str = _str.replace(QUOTE, "\"\"");
            needsTextQualifier = true;
        }
        if (_str.contains(_delimiter)) {
            needsTextQualifier = true;
        }
        if (_preserveNewlines) {
            needsTextQualifier = true;
        } else {
            _str = _str.replace('\n', ' ').replace('\r', ' ');
        }
        if (needsTextQualifier) {
            return QUOTE + _str + QUOTE;
        }
        return _str;
    }

    static String toSchemaRow(String _name, int _sqlType, int _nullable) {
        return String.format("{\"name\": \"%s\", \"type\": \"%s\", \"mode\": \"%s\"}", _name, Exporter.toBigQueryType(_sqlType), Exporter.toBigQueryNullable(_nullable));
    }

    static String toBigQueryType(int _sqlType) {
        switch (_sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "int64";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "float64";
            }
            case 93: {
                return "timestamp";
            }
            case 16: {
                return "bool";
            }
        }
        return "string";
    }

    static String toBigQueryNullable(int _nullable) {
        switch (_nullable) {
            case 0: {
                return "required";
            }
            case 1: 
            case 2: {
                return "nullable";
            }
        }
        return "nullable";
    }

    public static class Builder {
        private String delimiter = ";";
        private boolean includeBom = false;
        private boolean preserveNewlines = false;

        public Builder withDelimiter(String _delimiter) {
            this.delimiter = _delimiter;
            return this;
        }

        public Builder includeBom(boolean _includeBom) {
            this.includeBom = _includeBom;
            return this;
        }

        public Builder preserveNewlines(boolean _preverseNewlines) {
            this.preserveNewlines = _preverseNewlines;
            return this;
        }

        public Exporter build() {
            return new Exporter(this.delimiter, this.includeBom, this.preserveNewlines);
        }
    }
}

