/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.BlobAction;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.util.Try;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Cursor;
import shaded.io.github.spannm.jackcess.DataType;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import shaded.org.hsqldb.types.BlobData;

public class UpdateCommand
extends AbstractCursorCommand {
    private final List<? extends Column> tableColumns;
    private final IndexSelector indexSelector;
    private final Map<String, Object> rowPattern;
    private final Object[] modifiedRow;
    private final String execId;
    private List<Column> blobColumns;
    private final Table table;
    private boolean isRollbacking;

    public UpdateCommand(Table _table, Map<String, Object> _rowPattern, Object[] _modifiedRow, String _execId) {
        this.tableColumns = _table.getColumns();
        this.indexSelector = new IndexSelector(_table);
        this.rowPattern = _rowPattern;
        this.modifiedRow = _modifiedRow;
        this.execId = _execId;
        this.checkBlob(_modifiedRow);
        this.table = _table;
    }

    private void checkBlob(Object[] newRow2) {
        for (int i = 0; i < newRow2.length; ++i) {
            if (!(newRow2[i] instanceof BlobData)) continue;
            if (this.blobColumns == null) {
                this.blobColumns = new ArrayList<Column>();
            }
            this.blobColumns.add(this.tableColumns.get(i));
        }
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public IndexSelector getIndexSelector() {
        return this.indexSelector;
    }

    @Override
    public Map<String, Object> getRowPattern() {
        return this.rowPattern;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.UPDATE;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        Try.catching(() -> {
            Cursor cur = this.indexSelector.getCursor();
            if (cur.findNextRow(this.rowPattern)) {
                if (this.blobColumns != null) {
                    for (Column col : this.blobColumns) {
                        Object val;
                        this.modifiedRow[this.tableColumns.indexOf((Object)col)] = val = cur.getCurrentRowValue(col);
                    }
                }
                this.updateComplex(cur);
                this.persist(cur);
            }
        }).orThrow(UcanaccessSQLException::new);
        return new BlobAction(this.table, this.modifiedRow);
    }

    @Override
    public IFeedbackAction persistCurrentRow(Cursor cur) throws IOException {
        if (this.blobColumns != null) {
            for (Column col : this.blobColumns) {
                Object val;
                this.modifiedRow[this.tableColumns.indexOf((Object)col)] = val = cur.getCurrentRowValue(col);
            }
        }
        this.updateComplex(cur);
        this.persist(cur);
        return new BlobAction(this.table, this.modifiedRow);
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        Persist2Jet p2a = new Persist2Jet();
        UpdateCommand urev = new UpdateCommand(this.table, p2a.getRowPattern(this.modifiedRow, this.table), p2a.getValues(this.getRowPattern(), this.table), this.execId);
        urev.isRollbacking = true;
        return urev.persist();
    }

    private void updateComplex(Cursor cur) throws IOException {
        int j = 0;
        for (Column column : this.tableColumns) {
            if (column.getType() == DataType.COMPLEX_TYPE) {
                ComplexBase[] vs;
                ComplexValueForeignKey rowFk = (ComplexValueForeignKey)column.getRowValue(cur.getCurrentRow());
                if (this.modifiedRow[j] instanceof Attachment[]) {
                    rowFk.deleteAllValues();
                    Attachment[] atcs = (Attachment[])this.modifiedRow[j];
                    for (ComplexBase complexBase : atcs) {
                        rowFk.addAttachment(((Attachment)complexBase).getUrl(), ((Attachment)complexBase).getName(), ((Attachment)complexBase).getType(), ((Attachment)complexBase).getData(), ((Attachment)complexBase).getTimeStamp(), ((Attachment)complexBase).getFlags());
                    }
                } else if (this.modifiedRow[j] instanceof SingleValue[]) {
                    rowFk.deleteAllValues();
                    vs = (SingleValue[])this.modifiedRow[j];
                    for (ComplexBase complexBase : vs) {
                        rowFk.addMultiValue(((SingleValue)complexBase).getValue());
                    }
                } else if (this.modifiedRow[j] instanceof Version[] && (vs = (Version[])this.modifiedRow[j]).length > 0) {
                    LocalDateTime upTime;
                    ComplexBase v = vs[0];
                    List<shaded.io.github.spannm.jackcess.complex.Version> oldV = rowFk.getVersions();
                    String vn = ((Version)v).getValue();
                    String string = !oldV.isEmpty() ? oldV.get(0).getValue() : null;
                    LocalDateTime localDateTime = upTime = this.isRollbacking ? LocalDateTime.now() : ((Version)v).getModifiedDate();
                    if (vn != null && string == null || string != null && vn == null || string != null && vn != null && !string.equals(vn)) {
                        rowFk.addVersion(vn, upTime);
                    }
                }
            }
            ++j;
        }
    }

    private void persist(Cursor cur) throws IOException {
        Object[] mr = this.modifiedRow;
        if (this.table.getDatabase().getColumnOrder().equals((Object)Table.ColumnOrder.DISPLAY)) {
            Object[] newRowReorded = new Object[this.modifiedRow.length];
            int j = 0;
            for (Column column : this.table.getColumns()) {
                newRowReorded[column.getColumnIndex()] = this.modifiedRow[j];
                ++j;
            }
            mr = newRowReorded;
        }
        cur.updateCurrentRow(mr);
    }

    public String toString() {
        return String.format("%s[execId=%s, table=%s, tableColumns=%s]", this.getClass().getSimpleName(), this.execId, this.table, this.tableColumns);
    }
}

