/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.ucanaccess.commands.AddColumnCommand;
import net.ucanaccess.commands.AlterRenameCommand;
import net.ucanaccess.commands.CreateForeignKeyCommand;
import net.ucanaccess.commands.CreateIndexCommand;
import net.ucanaccess.commands.CreatePrimaryKeyCommand;
import net.ucanaccess.commands.CreateTableCommand;
import net.ucanaccess.commands.DropForeignKeyCommand;
import net.ucanaccess.commands.DropTableCommand;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.InvalidCreateStatementException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessStatement;
import shaded.io.github.spannm.jackcess.Database;

public class DDLCommandEnlist {
    private String[] types;
    private String[] defaults;
    private Boolean[] notNulls;
    private Map<String, String> columnMap = new HashMap<String, String>();

    private void enlistCreateTable(String _sql, SQLConverter.DDLType _ddlType) throws SQLException {
        CreateTableCommand c4io;
        String tn = _ddlType.getDBObjectName();
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        String execId = UcanaccessConnection.getCtxExcId();
        Connection hsqlConn = ac.getHSQLDBConnection();
        Database db = ac.getDbIO();
        LoadJet lfa = new LoadJet(hsqlConn, db);
        String ntn = tn;
        if (tn.startsWith("[") && tn.endsWith("]") || tn.startsWith("`") && tn.endsWith("`")) {
            ntn = SQLConverter.escapeIdentifier(tn.substring(1, tn.length() - 1));
        }
        lfa.synchronisationTriggers(ntn, true, true);
        if (_ddlType.equals((Object)SQLConverter.DDLType.CREATE_TABLE)) {
            this.parseTypesFromCreateStatement(_sql);
            c4io = new CreateTableCommand(tn, execId, this.columnMap, this.types, this.defaults, this.notNulls);
        } else {
            try (UcanaccessStatement st = ac.createStatement();){
                ResultSet rs = st.executeQuery(_ddlType.getSelect(_sql));
                ResultSetMetaData rsmd = rs.getMetaData();
                Metadata mt = new Metadata(ac.getHSQLDBConnection());
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    if (rsmd.getColumnName(i).equals(rsmd.getColumnLabel(i))) {
                        this.columnMap.put(mt.getEscapedColumnName(rsmd.getTableName(i), rsmd.getColumnName(i)), rsmd.getColumnLabel(i));
                        continue;
                    }
                    this.columnMap.put(SQLConverter.preEscapingIdentifier(rsmd.getColumnLabel(i)), rsmd.getColumnLabel(i));
                }
                c4io = new CreateTableCommand(tn, execId, this.columnMap);
            }
            catch (Exception _ignored) {
                c4io = new CreateTableCommand(tn, execId);
            }
        }
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    public void enlistDDLCommand(String sql, SQLConverter.DDLType ddlType) throws SQLException {
        switch (ddlType) {
            case CREATE_TABLE: 
            case CREATE_TABLE_AS_SELECT: {
                this.enlistCreateTable(sql, ddlType);
                break;
            }
            case DROP_TABLE: {
                this.enlistDropTable(ddlType);
                break;
            }
            case ALTER_RENAME: {
                this.enlistAlterRename(ddlType);
                break;
            }
            case ADD_COLUMN: {
                this.enlistAddColumn(sql, ddlType);
                break;
            }
            case CREATE_INDEX: {
                this.enlistCreateIndex(ddlType);
                break;
            }
            case CREATE_PRIMARY_KEY: {
                this.enlistCreatePrimaryKey(ddlType);
                break;
            }
            case CREATE_FOREIGN_KEY: {
                this.enlistCreateForeignKey(ddlType);
                break;
            }
            case DROP_FOREIGN_KEY: {
                this.enlistDropForeignKey(ddlType);
                break;
            }
        }
    }

    private void enlistCreateForeignKey(SQLConverter.DDLType _ddlType) throws SQLException {
        String tableName = _ddlType.getDBObjectName();
        String relationshipName = _ddlType.getSecondDBObjectName();
        String referencedTable = _ddlType.getThirdDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        CreateForeignKeyCommand c4io = new CreateForeignKeyCommand(tableName, referencedTable, execId, relationshipName);
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void enlistDropForeignKey(SQLConverter.DDLType ddlType) throws SQLException {
        String relationshipName = ddlType.getSecondDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        DropForeignKeyCommand c4io = new DropForeignKeyCommand(execId, relationshipName);
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void enlistCreatePrimaryKey(SQLConverter.DDLType ddlType) throws SQLException {
        String tableName = ddlType.getDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        CreatePrimaryKeyCommand c4io = new CreatePrimaryKeyCommand(tableName, execId);
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void enlistCreateIndex(SQLConverter.DDLType ddlType) throws SQLException {
        String indexName = ddlType.getDBObjectName();
        String tableName = ddlType.getSecondDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        CreateIndexCommand c4io = new CreateIndexCommand(indexName, tableName, execId);
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void enlistAddColumn(String sql, SQLConverter.DDLType ddlType) throws SQLException {
        String tableName = ddlType.getDBObjectName();
        String columnName = ddlType.getSecondDBObjectName();
        String columnDefinition = ddlType.getColumnDefinition();
        String execId = UcanaccessConnection.getCtxExcId();
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> defaultList = new ArrayList<String>();
        this.columnMap = new HashMap<String, String>();
        ArrayList<Boolean> notNullList = new ArrayList<Boolean>();
        String tknt = columnName + columnDefinition;
        this.parseColumnTypes(typeList, defaultList, notNullList, tknt);
        this.checkForOutOfPlaceNotNull(sql);
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        AddColumnCommand c4io = new AddColumnCommand(tableName, columnName, execId, this.columnMap, this.types, this.defaults, this.notNulls);
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void checkForOutOfPlaceNotNull(String sql) {
        if (SQLConverter.Patterns.NOT_NULL.matcher(sql).find() && this.notNulls.length > 0 && (this.notNulls[0] == null || !this.notNulls[0].booleanValue())) {
            this.notNulls[0] = true;
        }
    }

    private void enlistDropTable(SQLConverter.DDLType ddlType) throws SQLException {
        String tn = ddlType.getDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        DropTableCommand c4io = new DropTableCommand(tn, execId);
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private void enlistAlterRename(SQLConverter.DDLType ddlType) throws SQLException {
        String oldTn = ddlType.getDBObjectName();
        String newTn = ddlType.getSecondDBObjectName();
        String execId = UcanaccessConnection.getCtxExcId();
        UcanaccessConnection ac = UcanaccessConnection.getCtxConnection();
        AlterRenameCommand c4io = new AlterRenameCommand(oldTn, newTn, execId);
        ac.add(c4io);
        if (!ac.getAutoCommit()) {
            ac.commit();
        }
    }

    private String[] checkEscaped(String _ll, String _rl, String[] _colDecls, String _tknt) {
        if (_colDecls[0].startsWith(_ll) && _tknt.indexOf(_rl, 1) > 0) {
            for (int k = 0; k < _colDecls.length; ++k) {
                if (!_colDecls[k].endsWith(_rl)) continue;
                String[] colDecls0 = new String[_colDecls.length - k];
                colDecls0[0] = _tknt.substring(1, _tknt.substring(1).indexOf(_rl) + 1);
                System.arraycopy(_colDecls, 1 + k, colDecls0, 1, colDecls0.length - 1);
                _colDecls = colDecls0;
                break;
            }
        }
        return _colDecls;
    }

    private void parseColumnTypes(List<String> _typeList, List<String> _defaultList, List<Boolean> _notNullList, String _tknt) {
        String[] colDecls = _tknt.split("\\s+");
        colDecls = this.checkEscaped("[", "]", colDecls, _tknt);
        String escaped = SQLConverter.isListedAsKeyword((colDecls = this.checkEscaped("`", "`", colDecls, _tknt))[0]) ? colDecls[0].toUpperCase() : SQLConverter.basicEscapingIdentifier(colDecls[0]);
        this.columnMap.put(escaped, colDecls[0]);
        boolean reset = false;
        if (_tknt.matches("\\s*\\d+\\s*\\).*")) {
            reset = true;
            _tknt = _tknt.substring(_tknt.indexOf(41) + 1).trim();
            colDecls = _tknt.split("\\s+");
        }
        if (!reset && colDecls.length < 2) {
            return;
        }
        boolean decDef = false;
        if (!reset) {
            if (colDecls[1] != null && colDecls[1].toUpperCase().startsWith("NUMERIC(")) {
                colDecls[1] = "NUMERIC";
                decDef = true;
            }
            _typeList.add(colDecls[1]);
        }
        if ((colDecls.length > 2 || reset && colDecls.length == 2) && "not".equalsIgnoreCase(colDecls[colDecls.length - 2]) && "null".equalsIgnoreCase(colDecls[colDecls.length - 1])) {
            _notNullList.add(true);
        } else if (!decDef) {
            _notNullList.add(false);
        }
        if (!decDef) {
            _defaultList.add(this.value(SQLConverter.getDDLDefault(_tknt)));
        }
        this.types = _typeList.toArray(new String[0]);
        this.defaults = _defaultList.toArray(new String[0]);
        this.notNulls = _notNullList.toArray(new Boolean[0]);
    }

    private void parseTypesFromCreateStatement(String _sql) throws SQLException {
        int endDecl;
        Pattern pat = Pattern.compile("(\\s+)(?:DECIMAL|NUMERIC)\\s*\\(", 2);
        String sql = pat.matcher(_sql).replaceAll("$1NUMERIC(");
        int startDecl = sql.indexOf(40);
        if (startDecl >= (endDecl = sql.lastIndexOf(41))) {
            throw new InvalidCreateStatementException(sql);
        }
        String decl = sql.substring(startDecl + 1, endDecl);
        String[] tokens = decl.split(",");
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> defaultList = new ArrayList<String>();
        this.columnMap = new HashMap<String, String>();
        ArrayList<Boolean> notNullList = new ArrayList<Boolean>();
        for (String token : tokens) {
            String tknt = token.trim();
            this.parseColumnTypes(typeList, defaultList, notNullList, tknt);
        }
    }

    private String value(String _value) {
        if (_value == null) {
            return null;
        }
        if (_value.startsWith("\"") && _value.endsWith("\"")) {
            return _value.substring(1, _value.length() - 1).replace("\"\"", "\"");
        }
        if (_value.startsWith("'") && _value.endsWith("'")) {
            return _value.substring(1, _value.length() - 1).replace("''", "'");
        }
        return _value;
    }
}

