/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.rowio;

import java.math.BigDecimal;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.rowio.RowInputBase;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.types.BinaryData;
import shaded.org.hsqldb.types.BlobData;
import shaded.org.hsqldb.types.BlobDataID;
import shaded.org.hsqldb.types.ClobData;
import shaded.org.hsqldb.types.ClobDataID;
import shaded.org.hsqldb.types.IntervalMonthData;
import shaded.org.hsqldb.types.IntervalSecondData;
import shaded.org.hsqldb.types.IntervalType;
import shaded.org.hsqldb.types.JavaObjectData;
import shaded.org.hsqldb.types.TimeData;
import shaded.org.hsqldb.types.TimestampData;
import shaded.org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner = new Scanner();
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean noSeparators;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public void setSource(Session session, String string) {
        this.scanner.reset(session, string);
        this.statementType = 1;
        this.scanner.scanNext();
        int n = this.scanner.getTokenType();
        switch (n) {
            case 160: {
                this.statementType = 3;
                this.scanner.scanNext();
                this.scanner.scanNext();
                this.tableName = this.scanner.getString();
                this.scanner.scanNext();
                break;
            }
            case 96: {
                this.statementType = 2;
                this.scanner.scanNext();
                this.scanner.scanNext();
                this.tableName = this.scanner.getString();
                break;
            }
            case 54: {
                this.statementType = 4;
                break;
            }
            case 313: {
                this.scanner.scanNext();
                n = this.scanner.getTokenType();
                if (n != 502) break;
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean bl;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl2 = bl = this.scanner.getTokenType() == 924;
        if (bl) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (bl) {
            try {
                this.value = this.scanner.getDataType().negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    @Override
    public String readString() {
        this.readField();
        return (String)this.value;
    }

    @Override
    public char readChar() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public byte readByte() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public short readShort() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readInt() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public long readLong() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readType() {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    @Override
    protected Long readBigint() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (Long)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double readReal() {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object object = this.scanner.getValue();
        double d = ((Number)object).doubleValue();
        if (d != 0.0) throw Error.error(5585);
        if (((Number)this.value).doubleValue() == 1.0) {
            d = Double.POSITIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            d = Double.NEGATIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5585);
            d = Double.NaN;
        }
        this.value = d;
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bigDecimal = (BigDecimal)type.convertToDefaultType(null, this.value);
        return bigDecimal;
    }

    @Override
    protected TimeData readTime(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    @Override
    protected BinaryData readBit() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 1021) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readUUID() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanUUIDStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!string.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        this.scanner.scanNext();
        string = this.scanner.getString();
        if (!string.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList<Object> hsqlArrayList = new HsqlArrayList<Object>();
        this.noSeparators = true;
        int n = 0;
        while (!this.scanner.scanSpecialIdentifier("]")) {
            if (n > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object object = this.readData(type);
            hsqlArrayList.add(object);
            ++n;
        }
        this.noSeparators = false;
        Object[] objectArray = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(objectArray);
        return objectArray;
    }
}

