/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.persist;

import shaded.org.hsqldb.lib.DoubleIntIndex;
import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.CachedObjectBase;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class DoubleIntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 8;
    DoubleIntIndex table;

    public DoubleIntArrayCachedObject(int n) {
        this.table = new DoubleIntIndex(n, true);
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        int n;
        this.position = rowInputInterface.getFilePosition();
        int n2 = this.table.capacity();
        int[] nArray = this.table.getKeys();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            nArray[n] = rowInputInterface.readInt();
            if (nArray[n] == 0) continue;
            n3 = n;
        }
        nArray = this.table.getValues();
        for (n = 0; n < n2; ++n) {
            nArray[n] = rowInputInterface.readInt();
        }
        this.table.setSize(n3 + 1);
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.table.capacity();
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.table.capacity() * 8;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n;
        int n2 = this.table.capacity();
        rowOutputInterface.setStorageSize(this.storageSize);
        int[] nArray = this.table.getKeys();
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(nArray[n]);
        }
        nArray = this.table.getValues();
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(nArray[n]);
        }
        rowOutputInterface.writeEnd();
    }

    public void clear() {
        this.hasChanged |= this.table.size() > 0;
        this.table.clear();
    }

    public boolean removeKey(int n) {
        boolean bl = this.table.removeKey(n);
        this.hasChanged |= bl;
        return bl;
    }

    public boolean addKey(int n, int n2) {
        boolean bl = this.table.addOrReplaceUnique(n, n2);
        this.hasChanged |= bl;
        return bl;
    }

    public int getValue(int n) {
        return this.table.lookup(n, -1);
    }

    public int getValue(int n, int n2) {
        return this.table.lookup(n, n2);
    }
}

