/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.map;

import shaded.org.hsqldb.map.BaseHashMap;
import shaded.org.hsqldb.types.TimestampData;

public class ValuePoolHashMap
extends BaseHashMap {
    long hits;

    public ValuePoolHashMap(int n, int n2, int n3) throws IllegalArgumentException {
        super(n, 3, 0, true);
        this.maxCapacity = n2;
        this.purgePolicy = n3;
    }

    protected Integer getOrAddInteger(int n) {
        int n2;
        Integer n3;
        int n4 = this.hashIndex.getHashIndex(n);
        int n5 = this.hashIndex.hashTable[n4];
        int n6 = -1;
        while (n5 >= 0) {
            n3 = (Integer)this.objectKeyTable[n5];
            n2 = n3;
            if (n2 == n) {
                int n7 = this.accessCount.incrementAndGet();
                if (n7 < 0) {
                    this.resetAccessCount();
                    n7 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n5] = n7;
                ++this.hits;
                return n3;
            }
            if (n2 > n) break;
            n6 = n5;
            n5 = this.hashIndex.getNextLookup(n5);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(n);
        }
        n5 = this.hashIndex.linkNode(n4, n6);
        n3 = n;
        this.objectKeyTable[n5] = n3;
        n2 = this.accessCount.incrementAndGet();
        if (n2 < 0) {
            this.resetAccessCount();
            n2 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n5] = n2;
        return n3;
    }

    protected Long getOrAddLong(long l) {
        Long l2;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            l2 = (Long)this.objectKeyTable[n2];
            long l3 = l2;
            if (l3 == l) {
                int n4 = this.accessCount.incrementAndGet();
                if (n4 < 0) {
                    this.resetAccessCount();
                    n4 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n2] = n4;
                ++this.hits;
                return l2;
            }
            if (l3 > l) break;
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        l2 = l;
        this.objectKeyTable[n2] = l2;
        int n5 = this.accessCount.incrementAndGet();
        if (n5 < 0) {
            this.resetAccessCount();
            n5 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n2] = n5;
        return l2;
    }

    protected String getOrAddString(Object object) {
        String string;
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            string = (String)this.objectKeyTable[n2];
            if (object.equals(string)) {
                int n4 = this.accessCount.incrementAndGet();
                if (n4 < 0) {
                    this.resetAccessCount();
                    n4 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n2] = n4;
                ++this.hits;
                return string;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(object);
        }
        string = object.toString();
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = string;
        int n5 = this.accessCount.incrementAndGet();
        if (n5 < 0) {
            this.resetAccessCount();
            n5 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n2] = n5;
        return string;
    }

    protected String getOrAddSubString(String string, int n, int n2) {
        String string2;
        string = string.substring(n, n2);
        int n3 = this.hashIndex.getHashIndex(string.hashCode());
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            string2 = (String)this.objectKeyTable[n4];
            if (string.equals(string2)) {
                int n6 = this.accessCount.incrementAndGet();
                if (n6 < 0) {
                    this.resetAccessCount();
                    n6 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n4] = n6;
                ++this.hits;
                return string2;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(string);
        }
        string2 = new String(string.toCharArray());
        n4 = this.hashIndex.linkNode(n3, n5);
        this.objectKeyTable[n4] = string2;
        int n7 = this.accessCount.incrementAndGet();
        if (n7 < 0) {
            this.resetAccessCount();
            n7 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n4] = n7;
        return string2;
    }

    protected TimestampData getOrAddDate(long l) {
        TimestampData timestampData;
        int n = (int)l ^ (int)(l >>> 32);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            timestampData = (TimestampData)this.objectKeyTable[n3];
            if (timestampData.getSeconds() == l) {
                int n5 = this.accessCount.incrementAndGet();
                if (n5 < 0) {
                    this.resetAccessCount();
                    n5 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n3] = n5;
                ++this.hits;
                return timestampData;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(l);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        timestampData = new TimestampData(l);
        this.objectKeyTable[n3] = timestampData;
        int n6 = this.accessCount.incrementAndGet();
        if (n6 < 0) {
            this.resetAccessCount();
            n6 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n3] = n6;
        return timestampData;
    }

    protected Double getOrAddDouble(long l) {
        Double d;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            d = (Double)this.objectKeyTable[n2];
            if (Double.doubleToLongBits(d) == l) {
                int n4 = this.accessCount.incrementAndGet();
                if (n4 < 0) {
                    this.resetAccessCount();
                    n4 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n2] = n4;
                ++this.hits;
                return d;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        d = Double.longBitsToDouble(l);
        this.objectKeyTable[n2] = d;
        int n5 = this.accessCount.incrementAndGet();
        if (n5 < 0) {
            this.resetAccessCount();
            n5 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n2] = n5;
        return d;
    }

    protected Object getOrAddObject(Object object) {
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            Object object2 = this.objectKeyTable[n2];
            if (object2.equals(object)) {
                int n4 = this.accessCount.incrementAndGet();
                if (n4 < 0) {
                    this.resetAccessCount();
                    n4 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n2] = n4;
                ++this.hits;
                return object2;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(object);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = object;
        int n5 = this.accessCount.incrementAndGet();
        if (n5 < 0) {
            this.resetAccessCount();
            n5 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n2] = n5;
        return object;
    }
}

