/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.PeriodDefinition;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableWorks;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.navigator.RowIterator;
import shaded.org.hsqldb.types.DateTimeType;
import shaded.org.hsqldb.types.TimestampData;

class TablePeriodWorks {
    private Table table;
    private Session session;

    public TablePeriodWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    void addSystemPeriod(PeriodDefinition periodDefinition) {
        if (this.table.systemPeriod != null) {
            throw Error.error(5517);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.addSystemPeriod(periodDefinition);
    }

    void addApplicationPeriod(PeriodDefinition periodDefinition) {
        throw Error.error(1551);
    }

    void addSystemVersioning() {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5518);
        }
        this.table.isSystemVersioned = true;
    }

    void dropSystemPeriod(boolean bl) {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5517);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.dropSystemPeriod(bl);
    }

    void dropApplicationPeriod(boolean bl) {
        throw Error.error(1551);
    }

    void dropSystemVersioning(boolean bl) {
        if (!this.table.isSystemVersioned()) {
            throw Error.error(5518);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.dropSystemVersioning(bl);
        long l = DateTimeType.epochLimitTimestamp.getSeconds();
        this.removeOldRows(l);
        this.table.isSystemVersioned = false;
    }

    long removeOldRows(long l) {
        int n = this.table.systemPeriodEndColumn;
        long l2 = 0L;
        RowIterator rowIterator = this.table.rowIterator(this.session);
        while (rowIterator.next()) {
            TimestampData timestampData = (TimestampData)rowIterator.getField(n);
            if (timestampData.getSeconds() >= l) continue;
            rowIterator.removeCurrent();
        }
        return l2;
    }
}

