/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shaded.io.github.spannm.jackcess.impl.OleUtil;

public interface OleBlob
extends Blob,
Closeable {
    public void writeTo(OutputStream var1) throws IOException;

    public Content getContent() throws IOException;

    public static class Builder {
        public static final String PACKAGE_PRETTY_NAME = "Packager Shell Object";
        public static final String PACKAGE_TYPE_NAME = "Package";
        private ContentType _type;
        private byte[] _bytes;
        private InputStream _stream;
        private long _contentLen;
        private String _fileName;
        private String _filePath;
        private String _prettyName;
        private String _className;
        private String _typeName;

        public ContentType getType() {
            return this._type;
        }

        public byte[] getBytes() {
            return this._bytes;
        }

        public InputStream getStream() {
            return this._stream;
        }

        public long getContentLength() {
            return this._contentLen;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getFilePath() {
            return this._filePath;
        }

        public String getPrettyName() {
            return this._prettyName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public Builder withSimplePackageBytes(byte[] bytes) {
            this._bytes = bytes;
            this._contentLen = bytes.length;
            this.setDefaultPackageType();
            this._type = ContentType.SIMPLE_PACKAGE;
            return this;
        }

        public Builder withSimplePackageStream(InputStream in, long length) {
            this._stream = in;
            this._contentLen = length;
            this.setDefaultPackageType();
            this._type = ContentType.SIMPLE_PACKAGE;
            return this;
        }

        public Builder withSimplePackageFileName(String fileName) {
            this._fileName = fileName;
            this.setDefaultPackageType();
            this._type = ContentType.SIMPLE_PACKAGE;
            return this;
        }

        public Builder withSimplePackageFilePath(String filePath) {
            this._filePath = filePath;
            this.setDefaultPackageType();
            this._type = ContentType.SIMPLE_PACKAGE;
            return this;
        }

        public Builder withSimplePackage(File f) throws FileNotFoundException {
            this._fileName = f.getName();
            this._filePath = f.getAbsolutePath();
            return this.withSimplePackageStream(new FileInputStream(f), f.length());
        }

        public Builder withLinkFileName(String fileName) {
            this._fileName = fileName;
            this.setDefaultPackageType();
            this._type = ContentType.LINK;
            return this;
        }

        public Builder withLinkPath(String link) {
            this._filePath = link;
            this.setDefaultPackageType();
            this._type = ContentType.LINK;
            return this;
        }

        public Builder withLink(File f) {
            this._fileName = f.getName();
            this._filePath = f.getAbsolutePath();
            this.setDefaultPackageType();
            this._type = ContentType.LINK;
            return this;
        }

        private void setDefaultPackageType() {
            if (this._prettyName == null) {
                this._prettyName = PACKAGE_PRETTY_NAME;
            }
            if (this._className == null) {
                this._className = PACKAGE_TYPE_NAME;
            }
        }

        public Builder withOtherBytes(byte[] bytes) {
            this._bytes = bytes;
            this._contentLen = bytes.length;
            this._type = ContentType.OTHER;
            return this;
        }

        public Builder withOtherStream(InputStream in, long length) {
            this._stream = in;
            this._contentLen = length;
            this._type = ContentType.OTHER;
            return this;
        }

        public Builder withOther(File f) throws FileNotFoundException {
            return this.withOtherStream(new FileInputStream(f), f.length());
        }

        public Builder withPackagePrettyName(String prettyName) {
            this._prettyName = prettyName;
            return this;
        }

        public Builder withPackageClassName(String className) {
            this._className = className;
            return this;
        }

        public Builder withPackageTypeName(String typeName) {
            this._typeName = typeName;
            return this;
        }

        public OleBlob toBlob() throws IOException {
            return OleUtil.createBlob(this);
        }

        public static OleBlob fromInternalData(byte[] bytes) {
            return OleUtil.parseBlob(bytes);
        }
    }

    public static interface OtherContent
    extends PackageContent,
    EmbeddedContent {
    }

    public static interface CompoundContent
    extends PackageContent,
    EmbeddedContent,
    Iterable<Entry> {
        public Entry getEntry(String var1) throws IOException;

        public boolean hasContentsEntry() throws IOException;

        public Entry getContentsEntry() throws IOException;

        default public Stream<Entry> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public static interface Entry
        extends EmbeddedContent {
            public String getName();

            public CompoundContent getParent();
        }
    }

    public static interface SimplePackageContent
    extends PackageContent,
    EmbeddedContent {
        public String getFileName();

        public String getFilePath();

        public String getLocalFilePath();
    }

    public static interface LinkContent
    extends PackageContent {
        public String getFileName();

        public String getLinkPath();

        public String getFilePath();

        public InputStream getLinkStream() throws IOException;
    }

    public static interface EmbeddedContent
    extends Content {
        public long length();

        public InputStream getStream() throws IOException;

        public void writeTo(OutputStream var1) throws IOException;
    }

    public static interface PackageContent
    extends Content {
        public String getPrettyName();

        public String getClassName();

        public String getTypeName();
    }

    public static interface Content {
        public ContentType getType();

        public OleBlob getBlob();
    }

    public static enum ContentType {
        LINK,
        SIMPLE_PACKAGE,
        COMPOUND_STORAGE,
        OTHER,
        UNKNOWN;

    }
}

