/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.BaseNumericValue;

public class DoubleValue
extends BaseNumericValue {
    private final Double _val;

    public DoubleValue(Double val) {
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.DOUBLE;
    }

    @Override
    public Object get() {
        return this._val;
    }

    @Override
    protected Number getNumber() {
        return this._val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return this._val != 0.0;
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this._val;
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this._val);
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return ctx.getNumericConfig().format(this._val);
    }
}

