/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.util;

import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    ArrayList<Object[]> rows = new ArrayList();

    @Override
    public String getColumnName(int n) {
        return this.headers[n].toString();
    }

    public Class getColumnClass(int n) {
        Object object;
        if (this.rows.size() > 0 && (object = this.getValueAt(0, n)) != null) {
            if (object instanceof Timestamp || object instanceof Time) {
                return Object.class;
            }
            return object.getClass();
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public ArrayList<Object[]> getData() {
        return this.rows;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        Object[] objectArray = this.rows.get(n);
        if (n2 >= objectArray.length) {
            return null;
        }
        return objectArray[n2];
    }

    public void setHead(Object[] objectArray) {
        this.headers = Arrays.copyOf(objectArray, objectArray.length);
    }

    public void addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        this.rows.add(objectArray2);
    }

    public void clear() {
        this.rows.clear();
    }

    public void setJTable(JTable jTable) {
        this.jtable = jTable;
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            int n = component.getPreferredSize().width + 10;
            int n2 = Integer.MIN_VALUE;
            for (int j = 0; j < Math.min(tableModel.getRowCount(), 30); ++j) {
                TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(j, i);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(j, i), false, false, j, i);
                int n3 = component.getPreferredSize().width;
                if (n3 < n2) continue;
                n2 = n3;
            }
            tableColumn.setPreferredWidth(Math.max(n, n2) + 10);
        }
    }
}

