/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.map.BaseHashMap;

public class IntHashSet
extends BaseHashMap {
    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int n) throws IllegalArgumentException {
        super(n, 1, 0, false);
    }

    public IntHashSet(int[] nArray) {
        super(nArray.length, 1, 0, false);
        this.addAll(nArray);
    }

    public IntHashSet(int[] nArray, int[] nArray2) {
        super(nArray.length + nArray2.length, 1, 0, false);
        this.addAll(nArray);
        this.addAll(nArray2);
    }

    public boolean contains(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.containsIntKey(n);
        }
        return false;
    }

    public boolean contains(int n) {
        return super.containsIntKey(n);
    }

    public boolean add(Integer n) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.add(n2);
    }

    public boolean add(int n) {
        return (Boolean)super.addOrUpdate(n, 0L, null, null);
    }

    public boolean remove(int n) {
        return (Boolean)super.remove(n, 0L, null, null, false, false);
    }

    public int getStartMatchCount(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length && super.containsIntKey(nArray[n]); ++n) {
        }
        return n;
    }

    public boolean addAll(Collection<Integer> collection) {
        int n = this.size();
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return n != this.size();
    }

    public boolean addAll(IntHashSet intHashSet) {
        boolean bl = false;
        Iterator<Integer> iterator = intHashSet.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.nextInt());
        }
        return bl;
    }

    public boolean addAll(int[] nArray) {
        int n = this.size();
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
        return n != this.size();
    }

    public boolean containsAll(IntHashSet intHashSet) {
        Iterator<Integer> iterator = intHashSet.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(IntHashSet intHashSet) {
        int n = this.size();
        Iterator<Integer> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (intHashSet.contains(iterator.nextInt())) continue;
            iterator.remove();
        }
        return n != this.size();
    }

    public boolean removeAll(IntHashSet intHashSet) {
        int n = this.size();
        Iterator<Integer> iterator = intHashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            this.remove(n2);
        }
        return n != this.size();
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        return this.toIntArray(nArray, true);
    }

    public int[] toArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public Iterator<Integer> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }
}

