/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.Comparator;
import shaded.org.hsqldb.lib.HsqlHeap;

public class HsqlArrayHeap<E>
implements HsqlHeap<E> {
    protected Comparator<E> oc;
    protected int count;
    protected Object[] heap;

    public HsqlArrayHeap(int n, Comparator<E> comparator) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("" + n);
        }
        if (comparator == null) {
            throw new IllegalArgumentException("null comparator");
        }
        this.heap = new Object[n];
        this.oc = comparator;
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.heap[i] = null;
        }
        this.count = 0;
    }

    @Override
    public synchronized boolean add(E e) {
        if (e == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this.isFull()) {
            return false;
        }
        if (this.count >= this.heap.length) {
            this.increaseCapacity();
        }
        int n = this.count++;
        while (n > 0) {
            int n2 = n - 1 >>> 1;
            try {
                if (this.oc.compare(e, this.heap[n2]) >= 0) {
                    break;
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.toString());
            }
            this.heap[n] = this.heap[n2];
            n = n2;
        }
        this.heap[n] = e;
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized boolean isFull() {
        return this.count == Integer.MAX_VALUE;
    }

    @Override
    public synchronized E peek() {
        return (E)this.heap[0];
    }

    @Override
    public synchronized E remove() {
        int n;
        if (this.count == 0) {
            return null;
        }
        int n2 = 0;
        Object object = this.heap[n2];
        --this.count;
        if (this.count == 0) {
            this.heap[0] = null;
            return (E)object;
        }
        Object object2 = this.heap[this.count];
        this.heap[this.count] = null;
        while ((n = (n2 << 1) + 1) < this.count) {
            int n3;
            int n4 = (n2 << 1) + 2;
            int n5 = n3 = n4 >= this.count || this.oc.compare(this.heap[n], this.heap[n4]) < 0 ? n : n4;
            if (this.oc.compare(object2, this.heap[n3]) <= 0) break;
            this.heap[n2] = this.heap[n3];
            n2 = n3;
        }
        this.heap[n2] = object2;
        return (E)object;
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" : size=").append(this.count).append(' ').append('[');
        for (int i = 0; i < this.count; ++i) {
            stringBuilder.append(this.heap[i]);
            if (i + 1 >= this.count) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void increaseCapacity() {
        Object[] objectArray = this.heap;
        this.heap = new Object[3 * this.heap.length / 2 + 1];
        System.arraycopy(objectArray, 0, this.heap, 0, this.count);
    }
}

