/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.error;

import java.lang.reflect.Field;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.error.ErrorCode;
import shaded.org.hsqldb.lib.StringUtil;
import shaded.org.hsqldb.resources.ResourceBundleHandler;
import shaded.org.hsqldb.result.Result;

public final class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String defaultMessage = "S1000 General error";
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = ResourceBundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int n, String string) {
        HsqlException hsqlException = Error.error(n, string);
        return new RuntimeException(hsqlException.getMessage());
    }

    public static HsqlException error(int n, String string) {
        return Error.error(null, n, string);
    }

    public static HsqlException error(Throwable throwable, int n, String string) {
        Object object = Error.getMessage(n);
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new HsqlException(throwable, ((String)object).substring(6), ((String)object).substring(0, 5), -n);
    }

    public static HsqlException parseError(int n, String string, int n2) {
        Object object = Error.getMessage(n);
        if (string != null) {
            object = (String)object + ": " + string;
        }
        if (n2 > 1) {
            string = Error.getMessage(24);
            object = (String)object + " :" + string + n2;
        }
        return new HsqlException(null, ((String)object).substring(6), ((String)object).substring(0, 5), -n);
    }

    public static HsqlException error(int n) {
        return Error.error(null, n, 0, null);
    }

    public static HsqlException error(int n, Throwable throwable) {
        String string = Error.getMessage(n, 0, null);
        return new HsqlException(throwable, string.substring(0, 5), -n);
    }

    public static HsqlException error(Throwable throwable, int n, int n2, String[] stringArray) {
        String string = Error.getMessage(n, n2, stringArray);
        int n3 = n2 < 11 ? n : n2;
        return new HsqlException(throwable, string.substring(6), string.substring(0, 5), -n3);
    }

    public static HsqlException parseError(int n, int n2, int n3, String[] stringArray) {
        Object object = Error.getMessage(n, n2, stringArray);
        if (n3 > 1) {
            String string = Error.getMessage(24);
            object = (String)object + " :" + string + n3;
        }
        int n4 = n2 < 11 ? n : n2;
        return new HsqlException(null, ((String)object).substring(6), ((String)object).substring(0, 5), -n4);
    }

    public static HsqlException error(int n, int n2) {
        return Error.error(n, Error.getMessage(n2));
    }

    public static HsqlException error(String string, String string2) {
        int n = Error.getCode(string2);
        if (n < 1000) {
            n = 5800;
        }
        if (string == null) {
            string = Error.getMessage(n);
        }
        return new HsqlException(null, string, string2, n);
    }

    private static String insertStrings(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < stringArray.length && (n2 = string.indexOf(MESSAGE_TAG, n)) != -1; ++i) {
            stringBuilder.append(string, n, n2);
            stringBuilder.append(stringArray[i] == null ? "null exception message" : stringArray[i]);
            n = n2 + MESSAGE_TAG.length();
        }
        n2 = string.length();
        stringBuilder.append(string, n, n2);
        return stringBuilder.toString();
    }

    public static String getMessage(int n) {
        return Error.getMessage(n, 0, null);
    }

    public static String getStateString(int n) {
        return Error.getMessage(n, 0, null).substring(0, 5);
    }

    public static String getMessage(int n, int n2, String[] stringArray) {
        Object object = Error.getResourceString(n);
        if (n2 != 0) {
            object = (String)object + " " + Error.getResourceString(n2);
        }
        if (stringArray != null) {
            object = Error.insertStrings((String)object, stringArray);
        }
        return object;
    }

    private static String getResourceString(int n) {
        String string = StringUtil.toZeroPaddedString(n, 4, 4);
        String string2 = ResourceBundleHandler.getString(bundleHandle, string);
        if (string2 == null) {
            string2 = defaultMessage;
        }
        return string2;
    }

    public static HsqlException error(Result result) {
        return new HsqlException(result);
    }

    public static void printSystemOut(String string) {
        if (TRACESYSTEMOUT) {
            System.out.println(string);
        }
    }

    public static int getCode(String string) {
        try {
            Field[] fieldArray = ErrorCode.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string2 = fieldArray[i].getName();
                if (string2.length() != 7 || !string2.endsWith(string)) continue;
                return fieldArray[i].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

