/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.StatementDML;
import shaded.org.hsqldb.StatementQuery;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.navigator.RowSetNavigatorData;
import shaded.org.hsqldb.navigator.RowSetNavigatorDataChange;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    StatementResultUpdate() {
        this.writeTableNames = new HsqlNameManager.HsqlName[1];
        this.setCompileTimestamp(Long.MAX_VALUE);
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable throwable) {
            this.clearStructures(session);
            result = Result.newErrorResult(throwable);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        session.getTransactionUTC();
        this.checkAccessRights(session);
        Object[] objectArray = session.sessionContext.dynamicArguments;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        switch (this.actionType) {
            case 91: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] blArray = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    objectArray2[this.baseColumnMap[i]] = objectArray[i];
                    blArray[this.baseColumnMap[i]] = true;
                }
                int[] nArray = ArrayUtil.booleanArrayToIntIndexes(blArray);
                rowSetNavigatorDataChange.addRow(session, row, objectArray2, this.baseTable.getColumnTypes(), nArray);
                rowSetNavigatorDataChange.endMainDataSet();
                this.update(session, this.baseTable, rowSetNavigatorDataChange, null);
                break;
            }
            case 18: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                rowSetNavigatorDataChange.addRow(row);
                rowSetNavigatorDataChange.endMainDataSet();
                this.delete(session, this.baseTable, rowSetNavigatorDataChange, null);
                break;
            }
            case 55: {
                Object[] objectArray3 = this.baseTable.getNewRowData(session);
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    objectArray3[this.baseColumnMap[i]] = objectArray[i];
                }
                return this.insertSingleRow(session, persistentStore, objectArray3);
            }
        }
        return Result.updateOneResult;
    }

    Row getRow(Session session, Object[] objectArray) {
        int n = this.result.metaData.getColumnCount();
        Long l = (Long)objectArray[n];
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        Row row = null;
        if (n + 2 == this.result.metaData.getExtendedColumnCount()) {
            Object[] objectArray2 = ((RowSetNavigatorData)this.result.getNavigator()).getData(l);
            if (objectArray2 != null) {
                row = (Row)objectArray2[n + 1];
            }
        } else {
            int n2 = (int)l.longValue();
            row = (Row)persistentStore.get(n2, false);
        }
        this.result = null;
        return row;
    }

    void setRowActionProperties(Result result, int n, StatementQuery statementQuery, Type[] typeArray) {
        QueryExpression queryExpression = statementQuery.queryExpression;
        this.result = result;
        this.actionType = n;
        this.baseTable = queryExpression.getBaseTable();
        this.types = typeArray;
        this.baseColumnMap = queryExpression.getBaseTableColumnMap();
        this.writeTableNames[0] = this.baseTable.getName();
        this.rangeVariables = queryExpression.getRangeVariables();
        this.targetRangeVariables = queryExpression.getRangeVariables();
        this.sql = statementQuery.getSQL();
        this.parameterMetaData = queryExpression.getMetaData();
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 10: {
                break;
            }
            case 55: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 44: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 92: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 56: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

