/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.LongKeyHashMap;
import shaded.org.hsqldb.rights.User;

public class SessionManager {
    AtomicLong sessionIdCount = new AtomicLong();
    private final LongKeyHashMap<Session> sessionMap = new LongKeyHashMap();
    private final Session sysSession;
    private final Session sysLobSession;

    public SessionManager(Database database) {
        User user = database.getUserManager().getSysUser();
        this.sysSession = new Session(database, user, false, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
        this.sysLobSession = new Session(database, user, true, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
    }

    public synchronized Session newSession(Database database, User user, boolean bl, boolean bl2, TimeZone timeZone) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, user, bl2, bl, l, timeZone);
        this.sessionMap.put(l, session);
        return session;
    }

    public synchronized Session newSessionForLog(Database database) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, l, TimeZone.getTimeZone("GMT"));
        session.isProcessingLog = true;
        this.sessionMap.put(l, session);
        return session;
    }

    public Session getSysSessionForScript(Database database) {
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, 0L, TimeZone.getTimeZone("GMT"));
        session.setCurrentSchemaHsqlName(database.schemaManager.defaultSchemaHsqlName);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public synchronized Session newSysSession() {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, l, TimeZone.getTimeZone("GMT"));
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(l, session);
        return session;
    }

    public synchronized Session newSysSession(HsqlNameManager.HsqlName hsqlName, User user) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, user, false, false, l, TimeZone.getTimeZone("GMT"));
        session.currentSchema = hsqlName;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Session[] sessionArray = this.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            sessionArray[i].close();
        }
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            this.sessionMap.clear();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long l) {
        return this.sessionMap.get(l);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator<Session> iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = iterator.next();
            ++n;
        }
        return sessionArray;
    }

    public synchronized boolean isUserActive(String string) {
        Iterator<Session> iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = iterator.next();
            if (!session.isClosed() && string.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        Iterator<Session> iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = iterator.next();
            if (session.getCurrentSchemaHsqlName() == hsqlName) {
                session.resetSchema();
            }
            ++n;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator<Session> iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = iterator.next();
            session.loggedSchema = null;
            ++n;
        }
        this.sysLobSession.loggedSchema = null;
    }

    public synchronized long resetNewLobIDs() {
        Iterator<Session> iterator = this.sessionMap.values().iterator();
        long l = Long.MAX_VALUE;
        int n = 0;
        while (iterator.hasNext()) {
            Session session = iterator.next();
            long l2 = session.sessionData.newLobFloor;
            if (l2 != -1L && l2 < l) {
                l = l2;
            }
            session.sessionData.newLobFloor = -1L;
            ++n;
        }
        return l;
    }
}

