/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.RowAVL;
import shaded.org.hsqldb.TableBase;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.index.NodeAVL;
import shaded.org.hsqldb.index.NodeAVLDisk;
import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    volatile boolean isInMemory;
    boolean isNew;
    boolean isFromFile;
    boolean hasDataChanged;
    private boolean hasNodesChanged;

    public RowAVLDisk(TableBase tableBase, Object[] objectArray, PersistentStore persistentStore) {
        super(tableBase, objectArray);
        this.setNewNodes(persistentStore);
        this.isNew = true;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(PersistentStore persistentStore, RowInputInterface rowInputInterface) {
        super(persistentStore.getTable(), null);
        this.position = rowInputInterface.getFilePosition();
        this.storageSize = rowInputInterface.getSize();
        int n = persistentStore.getAccessorKeys().length;
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, rowInputInterface, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, rowInputInterface, i);
        }
        this.rowData = rowInputInterface.readData(this.table.getColumnTypes());
        this.isFromFile = true;
    }

    RowAVLDisk(TableBase tableBase) {
        super(tableBase, null);
    }

    @Override
    public NodeAVL insertNode(int n) {
        return null;
    }

    private void readRowInfo(RowInputInterface rowInputInterface) {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public void updateAccessCount(int n) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void setPos(long l) {
        this.position = l;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    @Override
    public synchronized void setChanged(boolean bl) {
        this.hasNodesChanged = bl;
        this.hasDataChanged = bl;
        this.isNew = bl;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public void delete(PersistentStore persistentStore) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public synchronized boolean keepInMemory(boolean bl) {
        if (!this.isInMemory) {
            return false;
        }
        if (bl) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public synchronized void setInMemory(boolean bl) {
        this.isInMemory = bl;
    }

    @Override
    public void setNewNodes(PersistentStore persistentStore) {
        int n = persistentStore.getAccessorKeys().length;
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, i);
        }
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return rowOutputInterface.getSize(this);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.writeNodes(rowOutputInterface);
        if (this.hasDataChanged) {
            rowOutputInterface.writeData(this, this.table.colTypes);
            rowOutputInterface.writeEnd();
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.write(rowOutputInterface, longLookup);
            nodeAVL = nodeAVL.nNext;
        }
        rowOutputInterface.writeData(this, this.table.colTypes);
        rowOutputInterface.writeEnd();
    }

    void writeNodes(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.write(rowOutputInterface);
            nodeAVL = nodeAVL.nNext;
        }
    }
}

