/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.types.Type;

public class ExpressionColumnAccessor
extends Expression {
    ColumnSchema column;

    ExpressionColumnAccessor(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
    }

    @Override
    String getAlias() {
        return this.column.getNameString();
    }

    @Override
    void collectObjectNames(Set<HsqlNameManager.HsqlName> set) {
        set.add(this.column.getName());
        if (this.column.getName().parent != null) {
            set.add(this.column.getName().parent);
        }
    }

    @Override
    String getColumnName() {
        return this.column.getNameString();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    @Override
    RangeVariable getRangeVariable() {
        return null;
    }

    @Override
    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List<Expression> list, boolean bl) {
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
    }

    @Override
    public Object getValue(Session session) {
        return null;
    }

    @Override
    public String getSQL() {
        return this.column.getName().statementName;
    }

    @Override
    protected String describe(Session session, int n) {
        return this.column.getName().name;
    }

    @Override
    public OrderedHashSet<Expression> getUnkeyedColumns(OrderedHashSet<Expression> orderedHashSet) {
        return orderedHashSet;
    }

    @Override
    OrderedHashSet<RangeVariable> collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet<RangeVariable> orderedHashSet) {
        return orderedHashSet;
    }

    @Override
    Expression replaceAliasInOrderBy(Session session, List<Expression> list, int n) {
        return this;
    }

    @Override
    Expression replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        return this;
    }

    @Override
    boolean hasReference(RangeVariable rangeVariable) {
        return false;
    }

    @Override
    boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        return this.column == expression.getColumn();
    }

    @Override
    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
    }

    @Override
    void resetColumnReferences() {
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return false;
    }

    @Override
    boolean isDynamicParam() {
        return false;
    }

    @Override
    public Type getDataType() {
        return this.column.getDataType();
    }
}

