/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnBase;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.ExpressionColumnAccessor;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.NumberSequence;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.HashSet;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.rights.Grantee;
import shaded.org.hsqldb.types.Type;
import shaded.org.hsqldb.types.Types;

public class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private HsqlNameManager.HsqlName columnName;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private Expression updateExpression;
    private NumberSequence sequence;
    private OrderedHashSet<HsqlNameManager.HsqlName> references;
    private OrderedHashSet<HsqlNameManager.HsqlName> generatedColumnReferences;
    private Expression accessor;
    private int systemPeriodType;

    ColumnSchema(HsqlNameManager.HsqlName hsqlName, Type type) {
        this.columnName = hsqlName;
        this.dataType = type;
    }

    public ColumnSchema(HsqlNameManager.HsqlName hsqlName, Type type, boolean bl, boolean bl2, Expression expression) {
        this.columnName = hsqlName;
        this.nullability = bl ? (byte)1 : 0;
        this.dataType = type;
        this.isPrimaryKey = bl2;
        this.defaultExpression = expression;
        this.setReferences();
    }

    @Override
    public int getType() {
        return this.columnName.type;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.columnName;
    }

    @Override
    public String getNameString() {
        return this.columnName.name;
    }

    @Override
    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.columnName.schema;
    }

    @Override
    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    @Override
    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    @Override
    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        return this.references;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        if (this.generatingExpression == null) {
            return;
        }
        this.generatingExpression.resetColumnReferences();
        this.generatingExpression.resolveCheckOrGenExpression(session, new RangeGroup.RangeGroupSimple(((Table)schemaObject).getDefaultRanges(), false), false);
        if (!this.dataType.canBeAssignedFrom(this.generatingExpression.getDataType())) {
            throw Error.error(5561);
        }
        this.setReferences();
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.parameterMode) {
            case 1: {
                stringBuilder.append("IN").append(' ');
                break;
            }
            case 4: {
                stringBuilder.append("OUT").append(' ');
                break;
            }
            case 2: {
                stringBuilder.append("INOUT").append(' ');
                break;
            }
        }
        if (this.columnName != null) {
            stringBuilder.append(this.columnName.statementName).append(' ');
        }
        stringBuilder.append(this.dataType.getTypeDefinition());
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public void setType(Type type) {
        this.dataType = type;
        this.setReferences();
    }

    public void setName(HsqlNameManager.HsqlName hsqlName) {
        this.columnName = hsqlName;
    }

    void setIdentity(NumberSequence numberSequence) {
        this.sequence = numberSequence;
        this.isIdentity = numberSequence != null;
    }

    void setType(ColumnSchema columnSchema) {
        this.nullability = columnSchema.nullability;
        this.dataType = columnSchema.dataType;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    @Override
    public boolean isNullable() {
        boolean bl = super.isNullable();
        if (bl && this.dataType.isDomainType()) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return bl;
    }

    @Override
    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean isAutoUpdate() {
        return this.updateExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    public void setUpdateExpression(Expression expression) {
        this.updateExpression = expression;
    }

    public Expression getUpdateExpression() {
        return this.updateExpression;
    }

    @Override
    public boolean isWriteable() {
        return this.isWriteable;
    }

    @Override
    public void setWriteable(boolean bl) {
        this.isWriteable = bl;
    }

    @Override
    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    public Object getDefaultValue(Session session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    public Object getGeneratedValue(Session session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String string = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return string;
    }

    Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    void setGeneratingExpression(Expression expression) {
        this.generatingExpression = expression;
        this.setWriteable(this.generatingExpression == null);
    }

    public boolean isSystemPeriod() {
        return this.systemPeriodType != 0;
    }

    public int getSystemPeriodType() {
        return this.systemPeriodType;
    }

    void setSystemPeriodType(int n) {
        this.systemPeriodType = n;
        boolean bl = n == 0;
        this.setWriteable(bl);
    }

    public ColumnSchema duplicate() {
        ColumnSchema columnSchema = new ColumnSchema(this.columnName, this.dataType, true, this.isPrimaryKey, this.defaultExpression);
        columnSchema.setNullability(this.nullability);
        columnSchema.setGeneratingExpression(this.generatingExpression);
        columnSchema.setIdentity(this.sequence);
        columnSchema.setUpdateExpression(this.updateExpression);
        columnSchema.setSystemPeriodType(this.systemPeriodType);
        return columnSchema;
    }

    public Expression getAccessor() {
        if (this.accessor == null) {
            this.accessor = new ExpressionColumnAccessor(this);
        }
        return this.accessor;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getGeneratedColumnReferences() {
        return this.generatedColumnReferences;
    }

    private void setReferences() {
        Object object;
        if (this.references != null) {
            this.references.clear();
        }
        if (this.generatedColumnReferences != null) {
            this.generatedColumnReferences.clear();
        }
        if (this.dataType.isDomainType() || this.dataType.isDistinctType()) {
            object = this.dataType.getName();
            if (this.references == null) {
                this.references = new OrderedHashSet();
            }
            this.references.add((HsqlNameManager.HsqlName)object);
        }
        if (this.generatingExpression != null) {
            object = new OrderedHashSet();
            this.generatingExpression.collectObjectNames((Set<HsqlNameManager.HsqlName>)object);
            Iterator iterator = ((HashSet)object).iterator();
            while (iterator.hasNext()) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
                if (hsqlName.type == 9 || hsqlName.type == 3) {
                    if (hsqlName.type != 9) continue;
                    if (this.generatedColumnReferences == null) {
                        this.generatedColumnReferences = new OrderedHashSet();
                    }
                    this.generatedColumnReferences.add(hsqlName);
                    continue;
                }
                if (this.references == null) {
                    this.references = new OrderedHashSet();
                }
                this.references.add(hsqlName);
            }
        }
    }
}

