/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class RandomContext {
    private Source _defRnd;
    private Map<Integer, Source> _rnds;
    private float _lastVal = 0.01953125f;

    public float getRandom(Integer seed) {
        Source rnd;
        if (seed == null) {
            if (this._defRnd == null) {
                this._defRnd = new SimpleSource(RandomContext.createRandom(System.currentTimeMillis()));
            }
            return this._defRnd.get();
        }
        if (this._rnds == null) {
            this._rnds = new HashMap<Integer, Source>();
        }
        if ((rnd = this._rnds.get(seed)) == null) {
            int seedInt = seed;
            rnd = seedInt > 0 ? new SimpleSource(RandomContext.createRandom(seedInt)) : (seedInt < 0 ? new ResetSource(RandomContext.createRandom(seedInt)) : new LastValSource());
            this._rnds.put(seed, rnd);
        }
        return rnd.get();
    }

    private float withLast(float lastVal) {
        this._lastVal = lastVal;
        return lastVal;
    }

    private void reset() {
        if (this._rnds != null) {
            this._rnds.clear();
        }
    }

    private static Random createRandom(long seed) {
        return new Random(seed);
    }

    private class LastValSource
    extends Source {
        private LastValSource() {
        }

        @Override
        protected float getImpl() {
            return RandomContext.this._lastVal;
        }
    }

    private class ResetSource
    extends Source {
        private final float _val;

        private ResetSource(Random rnd) {
            this._val = rnd.nextFloat();
        }

        @Override
        protected float getImpl() {
            RandomContext.this.reset();
            return this._val;
        }
    }

    private class SimpleSource
    extends Source {
        private final Random _rnd;

        private SimpleSource(Random rnd) {
            this._rnd = rnd;
        }

        @Override
        protected float getImpl() {
            return this._rnd.nextFloat();
        }
    }

    private abstract class Source {
        private Source() {
        }

        public float get() {
            return RandomContext.this.withLast(this.getImpl());
        }

        protected abstract float getImpl();
    }
}

