/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class NumberFormatter {
    public static final RoundingMode ROUND_MODE = RoundingMode.HALF_EVEN;
    private static final int FLT_SIG_DIGITS = 7;
    private static final int DBL_SIG_DIGITS = 15;
    private static final int DEC_SIG_DIGITS = 28;
    public static final MathContext FLT_MATH_CONTEXT = new MathContext(7, ROUND_MODE);
    public static final MathContext DBL_MATH_CONTEXT = new MathContext(15, ROUND_MODE);
    public static final MathContext DEC_MATH_CONTEXT = new MathContext(28, ROUND_MODE);
    private static final String NAN_STR = "1.#QNAN";
    private static final String POS_INF_STR = "1.#INF";
    private static final String NEG_INF_STR = "-1.#INF";
    private final TypeFormatter _fltFmt;
    private final TypeFormatter _dblFmt;
    private final TypeFormatter _decFmt;

    public NumberFormatter(DecimalFormatSymbols syms) {
        this._fltFmt = new TypeFormatter(7, syms);
        this._dblFmt = new TypeFormatter(15, syms);
        this._decFmt = new TypeFormatter(28, syms);
    }

    public String format(float f) {
        if (Float.isNaN(f)) {
            return NAN_STR;
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? NEG_INF_STR : POS_INF_STR;
        }
        return this._fltFmt.format(new BigDecimal(f, FLT_MATH_CONTEXT));
    }

    public String format(double d) {
        if (Double.isNaN(d)) {
            return NAN_STR;
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? NEG_INF_STR : POS_INF_STR;
        }
        return this._dblFmt.format(new BigDecimal(d, DBL_MATH_CONTEXT));
    }

    public String format(BigDecimal bd) {
        return this._decFmt.format(bd.round(DEC_MATH_CONTEXT));
    }

    private static ScientificFormat createScientificFormat(int prec, DecimalFormatSymbols syms) {
        DecimalFormat df = new DecimalFormat("0.#E00", syms);
        df.setMaximumIntegerDigits(1);
        df.setMaximumFractionDigits(prec);
        df.setRoundingMode(ROUND_MODE);
        return new ScientificFormat(df);
    }

    private static void maybeInsertExpPlus(StringBuffer sb, int eIdx) {
        if (sb.charAt(eIdx + 1) != '-') {
            sb.insert(eIdx + 1, '+');
        }
    }

    public static class ScientificFormat
    extends NumberFormat {
        private static final long serialVersionUID = 0L;
        private final NumberFormat _df;
        private final NotationType _type;

        public ScientificFormat(NumberFormat df) {
            this(df, NotationType.EXP_E_PLUS);
        }

        public ScientificFormat(NumberFormat df, NotationType type) {
            this._df = df;
            this._type = type;
        }

        @Override
        public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer sb = this._df.format(number, toAppendTo, pos);
            this._type.format(sb, sb.lastIndexOf("E"));
            return sb;
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaximumFractionDigits() {
            return this._df.getMaximumFractionDigits();
        }

        @Override
        public int getMinimumFractionDigits() {
            return this._df.getMinimumFractionDigits();
        }
    }

    private static final class TypeFormatter {
        private final DecimalFormat _df;
        private final ScientificFormat _dfS;
        private final int _prec;

        private TypeFormatter(int prec, DecimalFormatSymbols syms) {
            this._prec = prec;
            this._df = new DecimalFormat("0.#", syms);
            this._df.setMaximumIntegerDigits(prec);
            this._df.setMaximumFractionDigits(prec);
            this._df.setRoundingMode(ROUND_MODE);
            this._dfS = NumberFormatter.createScientificFormat(prec, syms);
        }

        public String format(BigDecimal bd) {
            bd = bd.stripTrailingZeros();
            int prec = bd.precision();
            int scale = bd.scale();
            int sigDigits = prec;
            if (scale < 0) {
                sigDigits -= scale;
            } else if (scale > prec) {
                sigDigits += scale - prec;
            }
            return sigDigits > this._prec ? this._dfS.format(bd) : this._df.format(bd);
        }
    }

    public static enum NotationType {
        EXP_E_MINUS{

            @Override
            protected void format(StringBuffer sb, int eIdx) {
            }
        }
        ,
        EXP_E_PLUS{

            @Override
            protected void format(StringBuffer sb, int eIdx) {
                NumberFormatter.maybeInsertExpPlus(sb, eIdx);
            }
        }
        ,
        EXP_e_MINUS{

            @Override
            protected void format(StringBuffer sb, int eIdx) {
                sb.setCharAt(eIdx, 'e');
            }
        }
        ,
        EXP_e_PLUS{

            @Override
            protected void format(StringBuffer sb, int eIdx) {
                sb.setCharAt(eIdx, 'e');
                NumberFormatter.maybeInsertExpPlus(sb, eIdx);
            }
        };


        protected abstract void format(StringBuffer var1, int var2);
    }
}

