/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import shaded.io.github.spannm.jackcess.impl.PageChannel;

public class ByteArrayBuilder {
    private int _pos;
    private final List<Data> _data = new ArrayList<Data>();

    public int position() {
        return this._pos;
    }

    public ByteArrayBuilder reserveInt() {
        return this.reserve(4);
    }

    public ByteArrayBuilder reserveShort() {
        return this.reserve(2);
    }

    public ByteArrayBuilder reserve(int bytes) {
        this._pos += bytes;
        return this;
    }

    public ByteArrayBuilder put(byte val) {
        return this.put(new ByteData(this._pos, val));
    }

    public ByteArrayBuilder putInt(int val) {
        return this.putInt(this._pos, val);
    }

    public ByteArrayBuilder putInt(int pos, int val) {
        return this.put(new IntData(pos, val));
    }

    public ByteArrayBuilder putShort(short val) {
        return this.putShort(this._pos, val);
    }

    public ByteArrayBuilder putShort(int pos, short val) {
        return this.put(new ShortData(pos, val));
    }

    public ByteArrayBuilder put(byte[] val) {
        return this.put(new BytesData(this._pos, val));
    }

    public ByteArrayBuilder put(ByteBuffer val) {
        return this.put(new BufData(this._pos, val));
    }

    private ByteArrayBuilder put(Data data) {
        this._data.add(data);
        int endPos = data.getEndPos();
        if (endPos > this._pos) {
            this._pos = endPos;
        }
        return this;
    }

    public ByteBuffer toBuffer() {
        return this.toBuffer(PageChannel.wrap(new byte[this._pos]));
    }

    public ByteBuffer toBuffer(ByteBuffer buf) {
        for (Data data : this._data) {
            data.write(buf);
        }
        buf.rewind();
        return buf;
    }

    public byte[] toArray() {
        return this.toBuffer().array();
    }

    private static final class BufData
    extends Data {
        private final ByteBuffer _val;

        private BufData(int pos, ByteBuffer val) {
            super(pos);
            this._val = val;
        }

        @Override
        public int size() {
            return this._val.remaining();
        }

        @Override
        public void write(ByteBuffer buf) {
            buf.position(this.getPos());
            buf.put(this._val);
        }
    }

    private static final class BytesData
    extends Data {
        private final byte[] _val;

        private BytesData(int pos, byte[] val) {
            super(pos);
            this._val = val;
        }

        @Override
        public int size() {
            return this._val.length;
        }

        @Override
        public void write(ByteBuffer buf) {
            buf.position(this.getPos());
            buf.put(this._val);
        }
    }

    private static final class ByteData
    extends Data {
        private final byte _val;

        private ByteData(int pos, byte val) {
            super(pos);
            this._val = val;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void write(ByteBuffer buf) {
            buf.put(this.getPos(), this._val);
        }
    }

    private static final class ShortData
    extends Data {
        private final short _val;

        private ShortData(int pos, short val) {
            super(pos);
            this._val = val;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void write(ByteBuffer buf) {
            buf.putShort(this.getPos(), this._val);
        }
    }

    private static final class IntData
    extends Data {
        private final int _val;

        private IntData(int pos, int val) {
            super(pos);
            this._val = val;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void write(ByteBuffer buf) {
            buf.putInt(this.getPos(), this._val);
        }
    }

    private static abstract class Data {
        private final int _pos;

        protected Data(int pos) {
            this._pos = pos;
        }

        public int getPos() {
            return this._pos;
        }

        public int getEndPos() {
            return this.getPos() + this.size();
        }

        public abstract int size();

        public abstract void write(ByteBuffer var1);
    }
}

