/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.rowio;

import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.persist.Crypto;
import shaded.org.hsqldb.rowio.RowOutputBinary;
import shaded.org.hsqldb.rowio.RowOutputInterface;
import shaded.org.hsqldb.types.Type;

public class RowOutputBinaryEncode
extends RowOutputBinary {
    final Crypto crypto;

    public RowOutputBinaryEncode(Crypto crypto, int n, int n2) {
        super(n, n2);
        this.crypto = crypto;
    }

    @Override
    public void writeData(Row row, Type[] typeArray) {
        if (this.crypto == null) {
            super.writeData(row, typeArray);
        } else {
            int n = this.count;
            this.ensureRoom(row.getStorageSize());
            this.writeInt(0);
            super.writeData(row, typeArray);
            int n2 = this.count - n - 4;
            int n3 = this.crypto.encode(this.buffer, n + 4, n2, this.buffer, n + 4);
            this.writeIntData(n3, n);
            this.count = n + 4 + n3;
        }
    }

    @Override
    public int getSize(Row row) {
        int n = super.getSize(row);
        if (this.crypto != null) {
            n = this.crypto.getEncodedSize(n - 4) + 8;
        }
        return n;
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinaryEncode(this.crypto, 128, this.scale);
    }
}

