/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.EventLogInterface;
import shaded.org.hsqldb.persist.RandomAccessInterface;

final class RAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;
    final EventLogInterface logger;

    RAFileSimple(EventLogInterface eventLogInterface, String string, String string2) throws IOException {
        this.file = new RandomAccessFile(string, string2);
        this.logger = eventLogInterface;
        this.readOnly = string2.equals("r");
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.file.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.file.writeLong(l);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l) {
        try {
            if (!this.readOnly && this.file.length() < l) {
                this.file.seek(l - 1L);
                this.file.writeByte(0);
            }
        }
        catch (IOException iOException) {
            this.logger.logWarningEvent("data file enlarge failed ", iOException);
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l) {
        try {
            this.file.setLength(l);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (Throwable throwable) {
            try {
                this.file.getFD().sync();
            }
            catch (Throwable throwable2) {
                this.logger.logSevereEvent("RA file sync error ", throwable);
                throw Error.error(throwable, 452, null);
            }
        }
    }
}

