/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.navigator;

import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.navigator.RowSetNavigator;
import shaded.org.hsqldb.result.ResultMetaData;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorClient
extends RowSetNavigator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table;

    public RowSetNavigatorClient() {
        this.table = emptyTable;
    }

    public RowSetNavigatorClient(int n) {
        this.table = new Object[n][];
    }

    public RowSetNavigatorClient(RowSetNavigator rowSetNavigator, int n, int n2) {
        this.size = rowSetNavigator.size;
        this.baseBlockSize = n2;
        this.currentOffset = n;
        this.table = new Object[n2][];
        rowSetNavigator.absolute(n);
        for (int i = 0; i < n2; ++i) {
            this.table[i] = rowSetNavigator.getCurrent();
            rowSetNavigator.next();
        }
        rowSetNavigator.beforeFirst();
    }

    public void setData(Object[][] objectArray) {
        this.table = objectArray;
        this.size = objectArray.length;
    }

    public void setData(int n, Object[] objectArray) {
        this.table[n] = objectArray;
    }

    public Object[] getData(int n) {
        return this.table[n];
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos >= this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    @Override
    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void removeCurrent() {
        System.arraycopy(this.table, this.currentPos + 1, this.table, this.currentPos, this.size - this.currentPos - 1);
        this.table[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    @Override
    public void add(Object[] objectArray) {
        this.ensureCapacity();
        this.table[this.size] = objectArray;
        ++this.size;
    }

    @Override
    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void clear() {
        this.setData(emptyTable);
        this.size = 0;
        this.reset();
    }

    @Override
    public void release() {
        this.setData(emptyTable);
        this.reset();
        this.isClosed = true;
    }

    @Override
    public boolean absolute(int n) {
        if (n < 0) {
            n += this.size;
        }
        if (n < 0) {
            this.beforeFirst();
            return false;
        }
        if (n >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        this.currentPos = n;
        return true;
    }

    @Override
    public void readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        this.size = rowInputInterface.readInt();
        if (this.table.length < this.size) {
            this.table = new Object[this.size][];
        }
        for (int i = 0; i < this.size; ++i) {
            this.table[i] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    @Override
    public void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        rowOutputInterface.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object[] objectArray = this.table[i];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        this.id = rowInputInterface.readLong();
        this.size = rowInputInterface.readInt();
        this.currentOffset = rowInputInterface.readInt();
        this.baseBlockSize = rowInputInterface.readInt();
        if (this.table.length < this.baseBlockSize) {
            this.table = new Object[this.baseBlockSize][];
        }
        for (int i = 0; i < this.baseBlockSize; ++i) {
            this.table[i] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        int n = this.size - this.currentOffset;
        if (n > this.table.length) {
            n = this.table.length;
        }
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(this.currentOffset);
        rowOutputInterface.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.table[i];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    void getBlock(int n) {
        try {
            RowSetNavigatorClient rowSetNavigatorClient = this.session.getRows(this.id, n, this.baseBlockSize);
            this.table = rowSetNavigatorClient.table;
            this.currentOffset = rowSetNavigatorClient.currentOffset;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int n = this.size == 0 ? 4 : this.size * 2;
            Object[][] objectArrayArray = new Object[n][];
            System.arraycopy(this.table, 0, objectArrayArray, 0, this.size);
            this.table = objectArrayArray;
        }
    }
}

