/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.HsqlByteArrayOutputStream;
import shaded.org.hsqldb.map.BitMap;

public class StringConverter {
    private static final byte[] HEXBYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static int getNibble(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return 10 + n - 97;
        }
        if (n >= 65 && n <= 70) {
            return 10 + n - 65;
        }
        return -1;
    }

    public static byte[] hexStringToByteArray(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n / 2 + n % 2];
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            int n4 = StringConverter.getNibble(c);
            if (n4 == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (bl) {
                n2 = (n4 & 0xF) << 4;
                bl = false;
                continue;
            }
            bl = true;
            byArray[n3++] = (byte)(n2 += n4 & 0xF);
        }
        if (!bl) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        if (n3 < byArray.length) {
            byArray = (byte[])ArrayUtil.resizeArray(byArray, n3);
        }
        return byArray;
    }

    public static BitMap sqlBitStringToBitMap(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        BitMap bitMap = new BitMap(0, true);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            int n3 = StringConverter.getNibble(c);
            if (n3 != 0 && n3 != 1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (n3 == 1) {
                bitMap.set(n2);
            }
            ++n2;
        }
        bitMap.setSize(n2);
        return bitMap;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            cArray[n2++] = (char)HEXBYTES[n3 >> 4 & 0xF];
            cArray[n2++] = (char)HEXBYTES[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static String byteArrayToSQLHexString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2 + 3];
        cArray[0] = 88;
        cArray[1] = 39;
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            cArray[n2++] = (char)HEXBYTES[n3 >> 4 & 0xF];
            cArray[n2++] = (char)HEXBYTES[n3 & 0xF];
        }
        cArray[n2] = 39;
        return new String(cArray);
    }

    public static String byteArrayToBitString(byte[] byArray, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i / 8];
            cArray[i] = BitMap.isSet(by, i % 8) ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String byteArrayToSQLBitString(byte[] byArray, int n) {
        char[] cArray = new char[n + 3];
        cArray[0] = 66;
        cArray[1] = 39;
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i / 8];
            cArray[n2++] = BitMap.isSet(by, i % 8) ? 49 : 48;
        }
        cArray[n2] = 39;
        return new String(cArray);
    }

    public static int writeHexBytes(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = byArray2[i] & 0xFF;
            byArray[n3++] = HEXBYTES[n4 >> 4 & 0xF];
            byArray[n3++] = HEXBYTES[n4 & 0xF];
        }
        return n3 - n;
    }

    public static String byteArrayToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void stringToUnicodeBytes(HsqlByteArrayOutputStream hsqlByteArrayOutputStream, String string, boolean bl) {
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        if (n == 0) {
            return;
        }
        hsqlByteArrayOutputStream.ensureRoom(n * 2 + 5);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i < n - 1 && string.charAt(i + 1) == 'u') {
                    hsqlByteArrayOutputStream.writeNoCheck(c);
                    hsqlByteArrayOutputStream.writeNoCheck(117);
                    hsqlByteArrayOutputStream.writeNoCheck(48);
                    hsqlByteArrayOutputStream.writeNoCheck(48);
                    hsqlByteArrayOutputStream.writeNoCheck(53);
                    hsqlByteArrayOutputStream.writeNoCheck(99);
                    n2 += 5;
                } else {
                    hsqlByteArrayOutputStream.write(c);
                }
            } else if (c >= ' ' && c <= '\u007f') {
                hsqlByteArrayOutputStream.writeNoCheck(c);
                if (c == '\'' && bl) {
                    hsqlByteArrayOutputStream.writeNoCheck(c);
                    ++n2;
                }
            } else {
                hsqlByteArrayOutputStream.writeNoCheck(92);
                hsqlByteArrayOutputStream.writeNoCheck(117);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c >> 12 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c >> 8 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c >> 4 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c & 0xF]);
                n2 += 5;
            }
            if (n2 <= n) continue;
            hsqlByteArrayOutputStream.ensureRoom(n + n2 + 5);
            n2 = 0;
        }
    }

    public static String unicodeStringToString(String string) {
        if (string == null || !string.contains("\\u")) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < n - 5) {
                char c2 = string.charAt(i + 1);
                if (c2 == 'u') {
                    ++i;
                    int n3 = StringConverter.getNibble(string.charAt(++i)) << 12;
                    n3 += StringConverter.getNibble(string.charAt(++i)) << 8;
                    n3 += StringConverter.getNibble(string.charAt(++i)) << 4;
                    cArray[n2++] = (char)(n3 += StringConverter.getNibble(string.charAt(++i)));
                    continue;
                }
                cArray[n2++] = c;
                continue;
            }
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    public static String readUTF(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        return StringConverter.readUTF(byArray, n, n2, cArray);
    }

    public static String readUTF(byte[] byArray, int n, int n2, char[] cArray) throws IOException {
        int n3 = 0;
        int n4 = 0;
        block4: while (n4 < n2) {
            int n5 = byArray[n + n4];
            if (n3 == cArray.length) {
                cArray = (char[])ArrayUtil.resizeArray(cArray, n2);
            }
            if (n5 > 0) {
                ++n4;
                cArray[n3++] = (char)n5;
                continue;
            }
            switch ((n5 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n4 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((n4 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 2];
                    byte by2 = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public static int stringToUTFBytes(String string, HsqlByteArrayOutputStream hsqlByteArrayOutputStream) {
        int n = string.length();
        int n2 = 0;
        if (hsqlByteArrayOutputStream.count + n + 8 > hsqlByteArrayOutputStream.buffer.length) {
            hsqlByteArrayOutputStream.ensureRoom(n + 8);
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)c;
                ++n2;
            } else if (c > '\u07ff') {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c & 0x3F);
                n2 += 3;
            } else {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c & 0x3F);
                n2 += 2;
            }
            if (hsqlByteArrayOutputStream.count + 8 <= hsqlByteArrayOutputStream.buffer.length) continue;
            hsqlByteArrayOutputStream.ensureRoom(n - i + 8);
        }
        return n2;
    }

    public static int getUTFSize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static String inputStreamToString(InputStream inputStream, String string) throws IOException {
        int n;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(1024);
        while ((n = inputStream.read()) != -1) {
            hsqlByteArrayOutputStream.write(n);
        }
        return new String(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size(), string);
    }

    public static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = bl ? StringConverter.count(string, c) : 0;
        int n2 = string.length();
        char[] cArray = new char[2 + n + n2];
        int n3 = 0;
        cArray[n3++] = c;
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            cArray[n3++] = c2;
            if (!bl || c2 != c) continue;
            cArray[n3++] = c2;
        }
        cArray[n3] = c;
        return new String(cArray);
    }

    static int count(String string, char c) {
        int n = 0;
        int n2 = 0;
        if (string != null) {
            while ((n = string.indexOf(c, n)) > -1) {
                ++n2;
                ++n;
            }
        }
        return n2;
    }

    public static void stringToHtmlBytes(HsqlByteArrayOutputStream hsqlByteArrayOutputStream, String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        hsqlByteArrayOutputStream.ensureRoom(n);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c > '\u007f' || c == '\"' || c == '&' || c == '<' || c == '>') {
                int n2 = Character.codePointAt(cArray, i);
                if (Character.charCount(n2) == 2) {
                    ++i;
                }
                hsqlByteArrayOutputStream.ensureRoom(16);
                hsqlByteArrayOutputStream.writeNoCheck(38);
                hsqlByteArrayOutputStream.writeNoCheck(35);
                hsqlByteArrayOutputStream.writeBytes(String.valueOf(n2));
                hsqlByteArrayOutputStream.writeNoCheck(59);
                continue;
            }
            if (c < ' ') {
                hsqlByteArrayOutputStream.writeNoCheck(32);
                continue;
            }
            hsqlByteArrayOutputStream.writeNoCheck(c);
        }
    }

    public static String toStringUUID(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 16) {
            throw new NumberFormatException();
        }
        char[] cArray = new char[36];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = (byArray[n] & 0xF0) >> 4;
            cArray[n2++] = (char)HEXBYTES[n3];
            n3 = byArray[n] & 0xF;
            cArray[n2++] = (char)HEXBYTES[n3];
            if (++n < 4 || n > 10 || n % 2 != 0) continue;
            cArray[n2++] = 45;
        }
        return new String(cArray);
    }

    public static int writeUUIDHexBytes(byte[] byArray, int n, byte[] byArray2) {
        if (byArray2.length != 16) {
            throw new NumberFormatException();
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4 = (byArray2[n3] & 0xF0) >> 4;
            byArray[n2++] = HEXBYTES[n4];
            n4 = byArray2[n3] & 0xF;
            byArray[n2++] = HEXBYTES[n4];
            if (++n3 < 4 || n3 > 10 || n3 % 2 != 0) continue;
            byArray[n2++] = 45;
        }
        return n2 - n;
    }

    public static byte[] toBinaryUUID(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() != 36) {
            throw new NumberFormatException();
        }
        byte[] byArray = new byte[16];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            char c = string.charAt(n2++);
            int n3 = StringConverter.getNibble(c);
            c = string.charAt(n2++);
            byArray[n] = (byte)((n3 << 4) + StringConverter.getNibble(c));
            if (++n < 4 || n > 10 || n % 2 != 0 || (c = string.charAt(n2++)) == '-') continue;
            throw new NumberFormatException();
        }
        return byArray;
    }

    static void appendHex(StringBuilder stringBuilder, char c) {
        for (int i = 12; i >= 0; i -= 4) {
            int n = c >>> i & 0xF;
            if (n < 10) {
                stringBuilder.append((char)(48 + n));
                continue;
            }
            stringBuilder.append((char)(65 + (n - 10)));
        }
    }

    public static String stringToUnicodeEscaped(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f' && c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('\\');
            StringConverter.appendHex(stringBuilder, c);
        }
        return stringBuilder.toString();
    }

    public static String unicodeEscapedToString(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (++i >= string.length()) {
                throw new UTFDataFormatException();
            }
            c = string.charAt(i);
            if (c == '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (i > string.length() - 4) {
                throw new UTFDataFormatException();
            }
            c = '\u0000';
            int n = 12;
            while (n >= 0) {
                int n2 = string.charAt(i);
                if ((n2 = StringConverter.getNibble(n2)) < 0) {
                    throw new UTFDataFormatException();
                }
                c = (char)(c | n2 << n);
                n -= 4;
                ++i;
            }
            stringBuilder.append(c);
            --i;
        }
        return stringBuilder.toString();
    }

    public static void toJSONString(String string, StringBuilder stringBuilder) {
        int n = string.length();
        stringBuilder.append('\"');
        int n2 = string.indexOf(34);
        if (n2 == -1 && string.indexOf(92) == -1) {
            stringBuilder.append(string);
            stringBuilder.append('\"');
            return;
        }
        stringBuilder.append(string, 0, n2);
        for (int i = n2; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuilder.append('\\');
                StringConverter.appendHex(stringBuilder, c);
                continue;
            }
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
    }
}

