/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import shaded.org.hsqldb.lib.HashMap;

public class OrderedHashMap<K, V>
extends HashMap<K, V> {
    public OrderedHashMap() {
        this(8);
    }

    public OrderedHashMap(int n) throws IllegalArgumentException {
        super(n);
        this.isList = true;
    }

    public K getKeyAt(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return (K)this.objectKeyTable[n];
    }

    public V getValueAt(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return (V)this.objectValueTable[n];
    }

    @Override
    public V get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return (V)this.objectValueTable[n];
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.removeObject(object, true);
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object = this.objectKeyTable[n];
        super.remove(0L, 0L, object, null, false, true);
    }

    public boolean add(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(k);
        if (n >= 0) {
            return false;
        }
        super.put(k, v);
        return true;
    }

    public V setValueAt(int n, V v) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object = this.objectValueTable[n];
        this.objectValueTable[n] = v;
        return (V)object;
    }

    public boolean insert(int n, K k, V v) throws IndexOutOfBoundsException {
        if (k == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.getLookup(k);
        if (n2 >= 0) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        super.put(k, v);
        return true;
    }

    public boolean set(int n, K k, V v) throws IndexOutOfBoundsException {
        if (k == null) {
            throw new NullPointerException();
        }
        this.checkRange(n);
        if (this.containsKey(k) && this.getIndex(k) != n) {
            return false;
        }
        super.remove(0L, 0L, this.objectKeyTable[n], null, false, false);
        super.put(k, v);
        return true;
    }

    public boolean setKeyAt(int n, K k) throws IndexOutOfBoundsException {
        if (k == null) {
            throw new NullPointerException();
        }
        this.checkRange(n);
        Object object = this.objectValueTable[n];
        return this.set(n, k, object);
    }

    public int getIndex(K k) {
        return this.getLookup(k);
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

