/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

public interface ObjectComparator<T> {
    public static final ObjectComparator defaultComparator = new DefaultComparator();
    public static final ObjectComparator identityComparator = new IdentityComparator();

    public boolean equals(T var1, T var2);

    public int hashCode(T var1);

    public long longKey(T var1);

    public static class DefaultComparator<T>
    implements ObjectComparator<T> {
        @Override
        public boolean equals(T t, T t2) {
            return t == t2 || t != null && t.equals(t2);
        }

        @Override
        public int hashCode(T t) {
            return t == null ? 0 : t.hashCode();
        }

        @Override
        public long longKey(T t) {
            return 0L;
        }
    }

    public static class IdentityComparator<T>
    implements ObjectComparator<T> {
        @Override
        public boolean equals(T t, T t2) {
            return t == t2;
        }

        @Override
        public int hashCode(T t) {
            return t == null ? 0 : t.hashCode();
        }

        @Override
        public long longKey(T t) {
            return 0L;
        }
    }
}

