/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import shaded.org.hsqldb.lib.HsqlByteArrayInputStream;
import shaded.org.hsqldb.lib.HsqlByteArrayOutputStream;

public final class InOutUtil {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 8192;
    public static final long DEFAULT_COPY_AMOUNT = Long.MAX_VALUE;

    private InOutUtil() {
    }

    public static int readLine(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            ++n2;
            outputStream.write(n);
            if (n != 10) continue;
            break;
        }
        return n2;
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(hsqlByteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        return hsqlByteArrayOutputStream.toByteArray();
    }

    public static Serializable deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        HsqlByteArrayInputStream hsqlByteArrayInputStream = new HsqlByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(hsqlByteArrayInputStream);
        return (Serializable)objectInputStream.readObject();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, Long.MAX_VALUE, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, l, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l, int n) throws IOException {
        int n2;
        int n3 = (int)Math.min((long)n, l);
        byte[] byArray = new byte[n3];
        long l2 = 0L;
        while (l2 < l && -1 != (n2 = inputStream.read(byArray, 0, n3))) {
            outputStream.write(byArray, 0, n2);
            l2 = (long)n2 > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : (l2 += (long)n2);
            if (l2 >= l) {
                return l2;
            }
            n3 = (int)Math.min((long)n, l - l2);
        }
        return l2;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return InOutUtil.copy(reader, writer, Long.MAX_VALUE, 8192);
    }

    public static long copy(Reader reader, Writer writer, long l) throws IOException {
        return InOutUtil.copy(reader, writer, l, 8192);
    }

    public static long copy(Reader reader, Writer writer, long l, int n) throws IOException {
        int n2;
        int n3 = (int)Math.min((long)n, l);
        char[] cArray = new char[n3];
        long l2 = 0L;
        while (l2 < l && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l2 = (long)n2 > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : (l2 += (long)n2);
            if (l2 >= l) {
                return l2;
            }
            n3 = (int)Math.min((long)n, l - l2);
        }
        return l2;
    }
}

