/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.auth;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.org.hsqldb.auth.AuthFunctionBean;
import shaded.org.hsqldb.jdbc.JDBCArrayBasic;
import shaded.org.hsqldb.lib.FrameworkLogger;
import shaded.org.hsqldb.types.Type;

public class AuthBeanMultiplexer {
    private static FrameworkLogger logger = FrameworkLogger.getLog(AuthBeanMultiplexer.class);
    private static AuthBeanMultiplexer singleton = new AuthBeanMultiplexer();
    private static Map<String, List<AuthFunctionBean>> beans = new HashMap<String, List<AuthFunctionBean>>();

    private AuthBeanMultiplexer() {
    }

    public static AuthBeanMultiplexer getSingleton() {
        return singleton;
    }

    public void clear() {
        beans.clear();
    }

    public void setAuthFunctionBeans(Map<String, List<AuthFunctionBean>> map) {
        if (beans.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(Map) only when the set is empty");
        }
        beans.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getUniqueNameFor(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("CALL database_name()");
            if (!resultSet.next()) {
                throw new SQLException("Engine did not reveal unique database name");
            }
            String string = resultSet.getString(1);
            return string;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.error("Failed to close ResultSet for retrieving db name");
                }
            }
            resultSet = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            statement = null;
        }
    }

    public void setAuthFunctionBeans(Connection connection, List<AuthFunctionBean> list) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(connection), list);
    }

    public void setAuthFunctionBeans(String string, List<AuthFunctionBean> list) {
        if (string == null || string.length() != 16) {
            throw new IllegalArgumentException("Database name not exactly 16 characters long: " + string);
        }
        List<AuthFunctionBean> list2 = beans.get(string);
        if (list2 == null) {
            list2 = new ArrayList<AuthFunctionBean>();
            beans.put(string, list2);
        } else if (list2.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(String, List) only when the db's AuthFunctionBean list is empty");
        }
        list2.addAll(list);
    }

    public void setAuthFunctionBean(Connection connection, AuthFunctionBean authFunctionBean) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(connection), Collections.singletonList(authFunctionBean));
    }

    public void setAuthFunctionBean(String string, AuthFunctionBean authFunctionBean) {
        this.setAuthFunctionBeans(string, Collections.singletonList(authFunctionBean));
    }

    public static Array authenticate(String string, String string2, String string3) throws Exception {
        if (string == null || string.length() != 16) {
            throw new IllegalStateException("Internal problem.  Database name not exactly 16 characters long: " + string);
        }
        List<AuthFunctionBean> list = beans.get(string);
        if (list == null) {
            logger.error("Database '" + string + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
            throw new IllegalArgumentException("Database '" + string + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
        }
        RuntimeException runtimeException = null;
        for (AuthFunctionBean authFunctionBean : list) {
            try {
                Object[] objectArray = authFunctionBean.authenticate(string2, string3);
                return objectArray == null ? null : new JDBCArrayBasic(objectArray, Type.SQL_VARCHAR);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                }
                logger.error("System failure of an AuthFunctionBean: " + (runtimeException2.getMessage() == null ? runtimeException2.toString() : runtimeException2.getMessage()));
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        throw runtimeException;
    }
}

