/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.Constraint;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.ExpressionBoolean;
import shaded.org.hsqldb.ExpressionColumn;
import shaded.org.hsqldb.ExpressionLogical;
import shaded.org.hsqldb.ExpressionValue;
import shaded.org.hsqldb.FunctionSQL;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.NumberSequence;
import shaded.org.hsqldb.ParserDML;
import shaded.org.hsqldb.PeriodDefinition;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.QuerySpecification;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.StatementQuery;
import shaded.org.hsqldb.StatementSchema;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableDerived;
import shaded.org.hsqldb.TableUtil;
import shaded.org.hsqldb.TableWorks;
import shaded.org.hsqldb.TextTable;
import shaded.org.hsqldb.Token;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.index.Index;
import shaded.org.hsqldb.lib.HashSet;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.OrderedIntHashSet;
import shaded.org.hsqldb.types.BinaryData;
import shaded.org.hsqldb.types.Type;

public class ParserTable
extends ParserDML {
    ParserTable(Session session, Scanner scanner) {
        super(session, scanner);
    }

    StatementSchema compileCreateTable(int n) {
        Table table;
        boolean bl = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (n) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, hsqlName, n);
                break;
            }
            default: {
                table = new Table(this.database, hsqlName, n);
            }
        }
        if (this.token.tokenType == 14) {
            return this.compileCreateTableAsSubqueryDefinition(table, bl);
        }
        return this.compileCreateTableBody(table, bl);
    }

    StatementSchema compileCreateTableBody(Table table, boolean bl) {
        Type[] typeArray;
        OrderedHashMap<String, Token> orderedHashMap;
        HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
        HsqlArrayList<Constraint> hsqlArrayList2 = new HsqlArrayList<Constraint>();
        StatementQuery statementQuery = null;
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        boolean bl2 = this.readTableContentsSource(table, hsqlArrayList, hsqlArrayList2);
        if (!bl2) {
            return this.compileCreateTableAsSubqueryDefinition(table, bl);
        }
        this.readTableVersioningClause(table);
        if (this.token.tokenType == 14) {
            this.read();
            orderedHashMap = null;
            orderedHashMap = this.readTableQuery();
            this.readThis(390);
            this.readThis(451);
            statementQuery = new StatementQuery(this.session, (QueryExpression)((Object)orderedHashMap), this.compileContext);
            hsqlNameArray = statementQuery.getTableNamesForRead();
            typeArray = ((QueryExpression)((Object)orderedHashMap)).getColumnTypes();
            if (table.getColumnCount() != typeArray.length) {
                throw Error.error(5593);
            }
            for (int i = 0; i < typeArray.length; ++i) {
                boolean bl3 = table.getColumn(i).getDataType().canBeAssignedFrom(typeArray[i]);
                if (bl3) continue;
                throw Error.error(5561);
            }
        }
        this.readTableOnCommitClause(table);
        if (this.database.sqlSyntaxMys && (orderedHashMap = super.readPropertyValuePairs(true, false)) != null && (typeArray = (Type[])orderedHashMap.get((Object)"COMMENT")) != null) {
            String string;
            table.getName().comment = string = typeArray.tokenString;
        }
        orderedHashMap = new OrderedHashSet();
        ((HashSet)((Object)orderedHashMap)).add(this.database.getCatalogName());
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Table table2;
            Constraint constraint = hsqlArrayList.get(i);
            HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
            if (hsqlName == null || (table2 = this.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name)) == null || table2.isTemp()) continue;
            ((HashSet)((Object)orderedHashMap)).add(table.getName());
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, hsqlArrayList, hsqlArrayList2, statementQuery, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray2 = new HsqlNameManager.HsqlName[orderedHashMap.size()];
        ((OrderedHashSet)((Object)orderedHashMap)).toArray(hsqlNameArray2);
        return new StatementSchema(string, 87, objectArray, hsqlNameArray, hsqlNameArray2);
    }

    boolean readTableContentsSource(Table table, HsqlArrayList<Constraint> hsqlArrayList, HsqlArrayList<Constraint> hsqlArrayList2) {
        int n = this.getPosition();
        this.readThis(926);
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        block8: while (!bl3) {
            Object object;
            switch (this.token.tokenType) {
                case 192: {
                    object = this.readLikeTable(table);
                    for (int i = 0; i < ((ColumnSchema[])object).length; ++i) {
                        table.addColumn(object[i]);
                    }
                    bl = false;
                    bl2 = false;
                    continue block8;
                }
                case 46: 
                case 59: 
                case 134: 
                case 268: 
                case 367: {
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, hsqlArrayList);
                    bl = false;
                    bl2 = false;
                    continue block8;
                }
                case 260: {
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    if (table.isTemp() || table.isText()) {
                        throw this.unexpectedToken();
                    }
                    object = this.readAndAddPeriod(table);
                    if (object == null) break;
                    bl = false;
                    bl2 = false;
                    continue block8;
                }
                case 913: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block8;
                }
                case 911: {
                    this.read();
                    bl3 = true;
                    continue block8;
                }
                case 510: 
                case 697: {
                    if (!this.database.sqlSyntaxMys) break;
                    this.readIndex(table, hsqlArrayList2);
                    bl = false;
                    bl2 = false;
                    continue block8;
                }
            }
            if (!bl2) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            object = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, (HsqlNameManager.HsqlName)object, hsqlArrayList);
            if (columnSchema == null) {
                if (bl) {
                    this.rewind(n);
                    return false;
                }
                throw Error.error(5000);
            }
            table.addColumn(columnSchema);
            bl = false;
            bl2 = false;
            if (columnSchema.getSystemPeriodType() == 1) {
                if (bl4) {
                    throw Error.error(5591);
                }
                bl4 = true;
                continue;
            }
            if (columnSchema.getSystemPeriodType() != 2) continue;
            if (bl5) {
                throw Error.error(5591);
            }
            bl5 = true;
        }
        if (table.getColumnCount() == 0) {
            throw Error.error(5591);
        }
        if (bl4 ^ bl5) {
            throw Error.error(5516);
        }
        if (bl4 && table.systemPeriod == null) {
            throw Error.error(5516);
        }
        this.setPeriodColumns(table, table.systemPeriod);
        this.setPeriodColumns(table, table.applicationPeriod);
        if (table.applicationPeriod != null) {
            throw Error.error(1551, table.applicationPeriod.getName().name);
        }
        return true;
    }

    void setPeriodColumns(Table table, PeriodDefinition periodDefinition) {
        if (periodDefinition == null) {
            return;
        }
        OrderedHashSet<String> orderedHashSet = periodDefinition.columnNames;
        ColumnSchema columnSchema = null;
        ColumnSchema columnSchema2 = null;
        HsqlNameManager.HsqlName hsqlName = periodDefinition.getName();
        int n = table.findColumn(hsqlName.name);
        if (n >= 0) {
            throw Error.error(5516, hsqlName.name);
        }
        for (int i = 0; i < 2; ++i) {
            String string = orderedHashSet.get(i);
            n = table.findColumn(string);
            if (n < 0) {
                throw Error.error(5501, string);
            }
            ColumnSchema columnSchema3 = table.getColumn(n);
            Type type = columnSchema3.getDataType();
            switch (periodDefinition.periodType) {
                case 1: {
                    if (!type.isTimestampType()) {
                        throw Error.error(5516, string);
                    }
                    if (!(i == 0 ? columnSchema3.getSystemPeriodType() != 1 : columnSchema3.getSystemPeriodType() != 2)) break;
                    throw Error.error(5516, string);
                }
                case 2: {
                    if (type.isDateOrTimestampType()) break;
                    throw Error.error(5516, string);
                }
            }
            if (i == 0) {
                columnSchema = columnSchema3;
                continue;
            }
            columnSchema2 = columnSchema3;
            if (columnSchema.getDataType().equals(columnSchema2.getDataType())) continue;
            throw Error.error(5516, string);
        }
        periodDefinition.startColumn = columnSchema;
        periodDefinition.endColumn = columnSchema2;
    }

    void checkPeriodColumnsAdd(Table table, PeriodDefinition periodDefinition) {
        if (periodDefinition == null) {
            return;
        }
        OrderedHashSet<String> orderedHashSet = periodDefinition.columnNames;
        HsqlNameManager.HsqlName hsqlName = periodDefinition.getName();
        int n = table.findColumn(hsqlName.name);
        if (n >= 0) {
            throw Error.error(5516, hsqlName.name);
        }
        for (int i = 0; i < 2; ++i) {
            String string = orderedHashSet.get(i);
            n = table.findColumn(string);
            if (n < 0) continue;
            throw Error.error(5504, string);
        }
    }

    void readTableVersioningClause(Table table) {
        if (table.systemPeriod != null && this.readIfThis(390)) {
            this.readThis(341);
            this.readThis(383);
            table.isSystemVersioned = true;
        }
    }

    void readTableOnCommitClause(Table table) {
        if (this.token.tokenType == 241) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(54);
            if (this.token.tokenType != 96 && this.token.tokenType == 575) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(299);
        }
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Table table2 = this.readTableName();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        while (true) {
            boolean bl4;
            boolean bl5 = bl4 = this.token.tokenType == 498;
            if (!bl4 && this.token.tokenType != 475) break;
            this.read();
            switch (this.token.tokenType) {
                case 488: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl = bl4;
                    break;
                }
                case 152: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = bl4;
                    break;
                }
                case 454: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl3 = bl4;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[table2.getColumnCount()];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            ColumnSchema columnSchema = table2.getColumn(i).duplicate();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnSchema.getName());
            columnSchema.setName(hsqlName);
            columnSchema.setPrimaryKey(false);
            if (bl2) {
                if (columnSchema.isIdentity()) {
                    columnSchema.setIdentity(columnSchema.getIdentitySequence().duplicate());
                }
            } else {
                columnSchema.setIdentity(null);
            }
            if (!bl3) {
                columnSchema.setDefaultExpression(null);
            }
            if (!bl) {
                columnSchema.setGeneratingExpression(null);
            }
            columnSchemaArray[i] = columnSchema;
        }
        return columnSchemaArray;
    }

    StatementSchema compileCreateTableAsSubqueryDefinition(Table table, boolean bl) {
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        boolean bl2 = true;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = null;
        StatementQuery statementQuery = null;
        QueryExpression queryExpression = null;
        if (this.token.tokenType == 926) {
            hsqlNameArray2 = this.readColumnNames(table.getName());
        }
        this.readThis(14);
        queryExpression = this.readTableQuery();
        this.readThis(390);
        if (this.token.tokenType == 226) {
            this.read();
            bl2 = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(451);
        if (this.token.tokenType == 241) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(54);
            if (this.token.tokenType != 96 && this.token.tokenType == 575) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(299);
        }
        if (hsqlNameArray2 == null) {
            hsqlNameArray2 = queryExpression.getResultColumnNames();
        } else if (hsqlNameArray2.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, hsqlNameArray2, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (bl2) {
            statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
            hsqlNameArray = statementQuery.getTableNamesForRead();
        }
        Object[] objectArray = new Object[]{table, new HsqlArrayList(), new HsqlArrayList(), statementQuery, bl};
        String string = this.getLastPart();
        HsqlNameManager.HsqlName[] hsqlNameArray3 = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string, 87, objectArray, hsqlNameArray, hsqlNameArray3);
        return statementSchema;
    }

    private QueryExpression readTableQuery() {
        this.readThis(926);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(911);
        return queryExpression;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList<Constraint> hsqlArrayList, HsqlArrayList<Constraint> hsqlArrayList2, boolean bl) {
        Constraint constraint = hsqlArrayList.get(0);
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
        constraint.setColumnsIndexes(table);
        table.createPrimaryKey(hsqlName, constraint.core.mainCols, true);
        if (constraint.core.mainCols != null) {
            Constraint constraint2 = new Constraint(constraint.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(constraint2);
            if (bl) {
                session.database.schemaManager.addSchemaObject(constraint2);
            }
        }
        block7: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint = hsqlArrayList.get(i);
            switch (constraint.getConstraintType()) {
                case 2: {
                    constraint.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(constraint.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    hsqlName = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
                    SchemaObject schemaObject = table.createAndAddIndexStructure(session, hsqlName, constraint.core.mainCols, null, null, true, true, false);
                    Constraint constraint3 = new Constraint(constraint.getName(), table, (Index)schemaObject, 2);
                    table.addConstraint(constraint3);
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint3);
                    continue block7;
                }
                case 0: {
                    ParserTable.addForeignKey(session, table, constraint, hsqlArrayList2);
                    continue block7;
                }
                case 3: {
                    SchemaObject schemaObject;
                    try {
                        constraint.prepareCheckConstraint(session, table);
                    }
                    catch (HsqlException hsqlException) {
                        if (session.isProcessingScript()) continue block7;
                        throw hsqlException;
                    }
                    table.addConstraint(constraint);
                    if (constraint.isNotNull()) {
                        schemaObject = table.getColumn(constraint.notNullColumnIndex);
                        schemaObject.setNullable(false);
                        table.setColumnTypeVars(constraint.notNullColumnIndex);
                    }
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint constraint, HsqlArrayList<Constraint> hsqlArrayList) {
        Object object;
        HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
        if (hsqlName == table.getName()) {
            constraint.core.mainTable = table;
        } else {
            object = session.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
            if (object == null) {
                if (hsqlArrayList == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                hsqlArrayList.add(constraint);
                return;
            }
            constraint.core.mainTable = object;
        }
        constraint.setColumnsIndexes(table);
        object = new TableWorks(session, table);
        ((TableWorks)object).checkCreateForeignKey(table, constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5523);
        }
        Index index = constraint2.getMainIndex();
        boolean bl = constraint.core.mainTable.getSchemaName() != table.getSchemaName();
        int n = session.database.schemaManager.getTableIndex(table);
        if (n != -1 && n < session.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newConstraintIndexName(table.getName(), constraint.getName(), session.database.sqlSysIndexNames);
        Index index2 = table.createAndAddIndexStructure(session, hsqlName2, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = session.database.nameManager.newAutoName("REF", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName3;
        constraint.core.mainIndex = index;
        constraint.core.refTable = table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        table.addConstraint(constraint);
        constraint.core.mainTable.addConstraint(new Constraint(hsqlName3, constraint));
        session.database.schemaManager.addSchemaObject(constraint);
    }

    Constraint readFKReferences(Table table, HsqlNameManager.HsqlName hsqlName, OrderedHashSet<String> orderedHashSet) {
        HsqlNameManager.HsqlName hsqlName2;
        OrderedHashSet<String> orderedHashSet2 = null;
        this.readThis(277);
        HsqlNameManager.HsqlName hsqlName3 = this.token.namePrefix == null ? table.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (table.getSchemaName() == hsqlName3 && table.getName().name.equals(this.token.tokenString)) {
            hsqlName2 = table.getName();
            this.read();
        } else {
            hsqlName2 = this.readFKTableName(hsqlName3);
        }
        if (this.token.tokenType == 926) {
            orderedHashSet2 = this.readColumnNames(false);
        }
        int n = 68;
        if (this.token.tokenType == 205) {
            this.read();
            switch (this.token.tokenType) {
                case 517: {
                    this.read();
                    break;
                }
                case 563: {
                    throw this.unsupportedFeature();
                }
                case 138: {
                    this.read();
                    n = 70;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int n2 = 3;
        int n3 = 3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 241) {
            this.read();
            if (!orderedIntHashSet.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 96) {
                this.read();
                if (this.token.tokenType == 313) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 94: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 232: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 417) {
                    this.read();
                    n2 = 0;
                    continue;
                }
                if (this.token.tokenType == 588) {
                    this.read();
                    continue;
                }
                this.readThis(226);
                this.readThis(402);
                continue;
            }
            if (this.token.tokenType == 371) {
                this.read();
                if (this.token.tokenType == 313) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 94: {
                            this.read();
                            n3 = 4;
                            continue block13;
                        }
                        case 232: {
                            this.read();
                            n3 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 417) {
                    this.read();
                    n3 = 0;
                    continue;
                }
                if (this.token.tokenType == 588) {
                    this.read();
                    continue;
                }
                this.readThis(226);
                this.readThis(402);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (this.readIfThis(229)) {
            this.readThis(455);
        }
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        return new Constraint(hsqlName, table.getName(), orderedHashSet, hsqlName2, orderedHashSet2, 0, n2, n3, n);
    }

    HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName hsqlName) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.token.tokenString, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = table == null ? this.database.nameManager.newHsqlName(hsqlName, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return hsqlName2;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList<Constraint> hsqlArrayList) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Expression expression = null;
        int n = 0;
        boolean bl5 = true;
        Expression expression2 = null;
        Expression expression3 = null;
        Type type = null;
        NumberSequence numberSequence = null;
        switch (this.token.tokenType) {
            case 488: {
                this.read();
                this.readThis(407);
                bl = true;
                bl4 = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 152: {
                this.read();
                bl2 = true;
                bl3 = true;
                type = Type.SQL_INTEGER;
                numberSequence = new NumberSequence(null, 0L, 1L, type);
                break;
            }
            case 913: {
                return null;
            }
            case 911: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            bl2 = true;
                            bl3 = true;
                            type = Type.SQL_BIGINT;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            bl2 = true;
                            type = Type.SQL_INTEGER;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        type = Type.SQL_BIGINT;
                        numberSequence = new NumberSequence(null, 1L, 1L, type);
                        break;
                    }
                }
                type = this.readTypeDefinition(true, true);
                if (!this.database.sqlSyntaxMys || !type.isDomainType() || !type.getName().name.equals("ENUM")) break;
                type.userTypeModifier = null;
                object4 = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                object3 = new Constraint((HsqlNameManager.HsqlName)object4, null, 3);
                hsqlArrayList.add((Constraint)object3);
                this.readThis(926);
                object2 = new ExpressionColumn(hsqlName.name);
                object = super.XreadInValueListConstructor(1);
                this.readThis(911);
                expression3 = new ExpressionLogical(54, (Expression)object2, (Expression)object);
                ((ExpressionLogical)expression3).setNoOptimisation();
                ((Constraint)object3).check = expression3;
            }
        }
        if (!bl && !bl2) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 232: {
                        this.read();
                        break;
                    }
                    case 229: {
                        this.read();
                        this.readThis(232);
                        bl5 = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 390: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 94: {
                    this.read();
                    expression2 = this.readDefaultClause(type);
                    if (expression2.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    numberSequence = ((ExpressionColumn)expression2).sequence;
                    expression2 = null;
                    bl2 = true;
                    break;
                }
                case 488: {
                    this.read();
                    if (this.token.tokenType == 33) {
                        this.read();
                        this.readThis(94);
                    } else {
                        this.readThis(407);
                        bl4 = true;
                    }
                    this.readThis(14);
                    switch (this.token.tokenType) {
                        case 152: {
                            this.read();
                            numberSequence = new NumberSequence(null, type);
                            numberSequence.setAlways(bl4);
                            if (this.token.tokenType == 926) {
                                this.read();
                                this.readSequenceOptions(numberSequence, false, false, true);
                                this.readThis(911);
                            }
                            bl2 = true;
                            break;
                        }
                        case 926: {
                            if (!bl4) {
                                throw this.unexpectedToken(488);
                            }
                            bl = true;
                            this.read();
                            expression = this.XreadValueExpression();
                            this.readThis(911);
                            break;
                        }
                        case 511: {
                            if (bl4) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                                throw this.unexpectedToken(this.token.namePrefix);
                            }
                            numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                            bl2 = true;
                            this.read();
                            break;
                        }
                        case 298: {
                            if (!type.isTimestampType()) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            if (this.readIfThis(330)) {
                                n = 1;
                            } else {
                                this.readThis(112);
                                n = 2;
                            }
                            if (type.typeCode != 93) break;
                            type = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                        }
                    }
                    break;
                }
                case 152: {
                    this.read();
                    bl2 = true;
                    bl3 = true;
                    numberSequence = new NumberSequence(null, 0L, 1L, type);
                }
            }
        }
        if (!bl && !bl2 && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            bl2 = true;
            numberSequence = new NumberSequence(null, 1L, 1L, type);
        }
        object4 = new ColumnSchema(hsqlName, type, bl5, false, expression2);
        if (expression3 != null) {
            expression3.setLeftNode(new ExpressionColumn((ColumnSchema)object4));
        }
        ((ColumnSchema)object4).setGeneratingExpression(expression);
        ((ColumnSchema)object4).setSystemPeriodType(n);
        this.readColumnConstraints(table, (ColumnSchema)object4, hsqlArrayList);
        if (this.token.tokenType == 152 && !bl2) {
            this.read();
            bl2 = true;
            bl3 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        if (this.token.tokenType == 488 && !bl2 && !bl) {
            this.read();
            if (this.token.tokenType == 33) {
                this.read();
                this.readThis(94);
            } else {
                this.readThis(407);
                bl4 = true;
            }
            this.readThis(14);
            this.readThis(152);
            numberSequence = new NumberSequence(null, type);
            numberSequence.setAlways(bl4);
            if (this.token.tokenType == 926) {
                this.read();
                this.readSequenceOptions(numberSequence, false, false, true);
                this.readThis(911);
            }
            bl2 = true;
        }
        if (bl2) {
            ((ColumnSchema)object4).setIdentity(numberSequence);
        }
        if (bl3 && !((ColumnSchema)object4).isPrimaryKey()) {
            object3 = new OrderedHashSet();
            ((HashSet)object3).add(((ColumnSchema)object4).getName().name);
            object2 = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            object = new Constraint((HsqlNameManager.HsqlName)object2, (OrderedHashSet<String>)object3, 4);
            ((Constraint)object).setSimpleIdentityPK();
            hsqlArrayList.set(0, (Constraint)object);
            ((ColumnSchema)object4).setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 94 && ((ColumnSchema)object4).getDefaultExpression() == null && ((ColumnSchema)object4).getIdentitySequence() == null) {
            this.read();
            expression2 = this.readDefaultClause(type);
            if (expression2.opType == 12) {
                numberSequence = ((ExpressionColumn)expression2).sequence;
                expression2 = null;
            }
            ((ColumnSchema)object4).setDefaultExpression(expression2);
            ((ColumnSchema)object4).setIdentity(numberSequence);
        }
        return object4;
    }

    PeriodDefinition readAndAddPeriod(Table table) {
        PeriodDefinition periodDefinition = this.readPeriod(table);
        if (periodDefinition == null) {
            return null;
        }
        if (periodDefinition.getPeriodType() == 1) {
            table.systemPeriod = periodDefinition;
        } else {
            table.applicationPeriod = periodDefinition;
        }
        return periodDefinition;
    }

    PeriodDefinition readPeriod(Table table) {
        int n = 0;
        HsqlNameManager.HsqlName hsqlName = null;
        int n2 = this.getPosition();
        this.readThis(260);
        if (this.token.tokenType != 133) {
            this.rewind(n2);
            return null;
        }
        this.readThis(133);
        if (this.token.tokenType == 342) {
            n = 1;
            hsqlName = this.database.nameManager.newHsqlName(table.getName().schema, this.token.tokenString, false, 30);
        } else {
            n = 2;
            this.checkIsNonReservedIdentifier();
            this.checkIsIrregularCharInIdentifier();
            this.checkIsSimpleName();
            hsqlName = this.database.nameManager.newHsqlName(table.getName().schema, this.token.tokenString, this.isDelimitedIdentifier(), 30);
        }
        this.read();
        hsqlName.parent = table.getName();
        OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
        if (orderedHashSet.size() != 2) {
            throw Error.error(5593);
        }
        PeriodDefinition periodDefinition = new PeriodDefinition(hsqlName, n, orderedHashSet);
        if (periodDefinition.getPeriodType() == 1 ? table.systemPeriod != null : table.applicationPeriod != null) {
            throw Error.error(5581);
        }
        return periodDefinition;
    }

    void readConstraint(SchemaObject schemaObject, HsqlArrayList<Constraint> hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.token.tokenType == 59) {
            this.read();
            hsqlName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 268: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(510);
                Constraint constraint = hsqlArrayList.get(0);
                if (constraint.getConstraintType() == 4 && !constraint.isSimpleIdentityPK) {
                    throw Error.error(5532);
                }
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
                Constraint constraint2 = new Constraint(hsqlName, orderedHashSet, 4);
                hsqlArrayList.set(0, constraint2);
                break;
            }
            case 367: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                if (this.database.sqlSyntaxMys && !this.readIfThis(697)) {
                    this.readIfThis(510);
                }
                OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, orderedHashSet, 2);
                hsqlArrayList.add(constraint);
                break;
            }
            case 134: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(510);
                OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
                Constraint constraint = this.readFKReferences((Table)schemaObject, hsqlName, orderedHashSet);
                hsqlArrayList.add(constraint);
                break;
            }
            case 46: {
                this.read();
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, null, 3);
                this.readCheckConstraintCondition(constraint);
                hsqlArrayList.add(constraint);
                break;
            }
            default: {
                if (hsqlName == null) break;
                throw this.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema columnSchema, HsqlArrayList<Constraint> hsqlArrayList) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (columnSchema.getDataType().isTimestampType() && this.token.tokenType == 241) {
            int n = this.getPosition();
            try {
                this.read();
                this.readThis(371);
                if (this.readIfThis(82)) {
                    object = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                } else {
                    this.readThis(198);
                    object = FunctionSQL.newSQLFunction("LOCALTIMESTAMP", this.compileContext);
                }
                ((FunctionSQL)object).resolveTypes(this.session, null);
                columnSchema.setUpdateExpression((Expression)object);
            }
            catch (Exception exception) {
                this.rewind(n);
            }
        }
        do {
            HsqlNameManager.HsqlName hsqlName = null;
            if (this.token.tokenType == 59) {
                this.read();
                hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 268: {
                    if (bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(510);
                    object = hsqlArrayList.get(0);
                    if (((Constraint)object).getConstraintType() == 4) {
                        throw Error.error(5532);
                    }
                    OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
                    orderedHashSet.add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
                    hsqlArrayList.set(0, constraint);
                    columnSchema.setPrimaryKey(true);
                    bl4 = true;
                    break;
                }
                case 367: {
                    this.read();
                    object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    OrderedHashSet<String> orderedHashSet = new Constraint(hsqlName, (OrderedHashSet<String>)object, 2);
                    hsqlArrayList.add((Constraint)((Object)orderedHashSet));
                    break;
                }
                case 134: {
                    this.read();
                    this.readThis(510);
                }
                case 277: {
                    object = new OrderedHashSet<String>();
                    ((HashSet)object).add(columnSchema.getName().name);
                    OrderedHashSet<String> orderedHashSet = this.readFKReferences(table, hsqlName, (OrderedHashSet<String>)object);
                    hsqlArrayList.add((Constraint)((Object)orderedHashSet));
                    break;
                }
                case 46: {
                    this.read();
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    object = new Constraint(hsqlName, null, 3);
                    this.readCheckConstraintCondition((Constraint)object);
                    OrderedHashSet<String> orderedHashSet = ((Constraint)object).getCheckColumnExpressions();
                    for (int i = 0; i < orderedHashSet.size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)orderedHashSet.get(i);
                        if (columnSchema.getName().name.equals(expressionColumn.getColumnName())) {
                            if (expressionColumn.getSchemaName() == null || expressionColumn.getSchemaName().equals(table.getSchemaName().name)) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    hsqlArrayList.add((Constraint)object);
                    break;
                }
                case 229: {
                    if (bl2 || bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(232);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    object = new Constraint(hsqlName, null, 3);
                    ((Constraint)object).check = new ExpressionLogical(columnSchema);
                    hsqlArrayList.add((Constraint)object);
                    bl2 = true;
                    break;
                }
                case 232: {
                    if (bl2 || bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
    }

    void readCheckConstraintCondition(Constraint constraint) {
        this.readThis(926);
        Expression expression = this.XreadBooleanValueExpression();
        expression.setNoOptimisation();
        this.readThis(911);
        constraint.check = expression;
    }

    Expression readDefaultClause(Type type) {
        Expression expression = null;
        boolean bl = false;
        if (this.token.tokenType == 232) {
            this.read();
            return new ExpressionValue(null, type);
        }
        if (type.isDateTimeType() || type.isIntervalType()) {
            switch (this.token.tokenType) {
                case 87: 
                case 165: 
                case 349: 
                case 350: {
                    expression = this.readDateTimeIntervalLiteral(this.session);
                    if (expression.dataType.typeCode != type.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object object = expression.getValue(this.session, type);
                    return new ExpressionValue(object, type);
                }
                case 1011: {
                    break;
                }
                default: {
                    expression = this.XreadDateTimeValueFunctionOrNull();
                    if (expression == null) break;
                    expression = this.XreadModifier(expression);
                    break;
                }
            }
        } else if (type.isNumberType()) {
            if (this.database.sqlSyntaxPgs && this.token.tokenType == 747) {
                return this.readNextvalFunction();
            }
            if (this.database.sqlDoubleNaN && type.typeCode == 8) {
                expression = this.XreadNumericValueExpression();
            } else if (this.token.tokenType == 924) {
                this.read();
                bl = true;
            }
        } else if (type.isCharacterType()) {
            switch (this.token.tokenType) {
                case 74: 
                case 77: 
                case 78: 
                case 80: 
                case 84: 
                case 312: 
                case 343: 
                case 373: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    expression = this.readSQLFunction(functionSQL);
                    break;
                }
            }
        } else if (type.isBooleanType()) {
            switch (this.token.tokenType) {
                case 362: {
                    this.read();
                    return new ExpressionBoolean(true);
                }
                case 127: {
                    this.read();
                    return new ExpressionBoolean(false);
                }
            }
        } else if (type.isBitType()) {
            switch (this.token.tokenType) {
                case 362: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, type);
                }
                case 127: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, type);
                }
            }
        } else if (type.isArrayType()) {
            expression = this.readCollection(19);
            if (expression.nodes.length > 0) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            expression.dataType = type;
            return expression;
        }
        if (expression != null) {
            expression.resolveTypes(this.session, null);
            if (!type.canBeAssignedFrom(expression.getDataType())) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            return expression;
        }
        boolean bl2 = false;
        if ((this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && this.token.tokenType == 926) {
            this.read();
            bl2 = true;
        }
        if (this.token.tokenType == 1011) {
            Object object = this.token.tokenValue;
            Type type2 = this.token.dataType;
            Type type3 = type;
            if (type.typeCode == 40) {
                type3 = Type.getType(12, null, this.database.collation, type.precision, 0);
            } else if (type.typeCode == 30) {
                type3 = Type.getType(61, null, null, type.precision, 0);
            }
            if (bl) {
                object = type2.negate(object);
            }
            object = type3.convertToType(this.session, object, type2);
            this.read();
            if (bl2) {
                this.readThis(911);
            }
            return new ExpressionValue(object, type3);
        }
        if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxPgs) && (expression = this.XreadAllTypesCommonValueExpression(false)) != null) {
            QuerySpecification querySpecification;
            TableDerived tableDerived;
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                querySpecification.setReturningResult();
            }
            expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, RangeGroup.emptyArray, null, true);
            expression.resolveTypes(this.session, null);
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                Table table = querySpecification.getRangeVariables()[0].getTable();
                if (table != this.session.database.schemaManager.dualTable || querySpecification.exprColumns.length != 1) {
                    throw Error.error(5565);
                }
                expression = querySpecification.exprColumns[0];
            }
            if (bl2) {
                this.readThis(911);
            }
            return expression;
        }
        if (this.database.sqlSyntaxDb2) {
            Object object = null;
            switch (type.typeComparisonGroup) {
                case 12: {
                    object = "";
                    break;
                }
                case 61: {
                    object = BinaryData.zeroLengthBinary;
                    break;
                }
                case 2: {
                    object = 0;
                    break;
                }
                case 16: {
                    object = Boolean.FALSE;
                    break;
                }
                case 40: {
                    object = "";
                    return new ExpressionValue(object, Type.SQL_VARCHAR_DEFAULT);
                }
                case 30: {
                    object = BinaryData.zeroLengthBinary;
                    return new ExpressionValue(object, Type.SQL_VARBINARY_DEFAULT);
                }
                case 92: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIME", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 91: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_DATE", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 93: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
            }
            object = type.convertToDefaultType(this.session, object);
            return new ExpressionValue(object, type);
        }
        if (bl2) {
            this.readThis(911);
        }
        throw this.unexpectedToken();
    }

    void readSequenceOptions(NumberSequence numberSequence, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block10: do {
            bl4 = false;
            if (orderedIntHashSet.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 14: {
                    if (bl) {
                        orderedIntHashSet.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        numberSequence.setDefaults(numberSequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 330: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(390);
                    long l = this.readBigint();
                    numberSequence.setStartValueNoCheck(l);
                    if (!bl3) continue block10;
                    this.readIfThis(913);
                    break;
                }
                case 587: {
                    if (!bl2) {
                        bl4 = true;
                        break;
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(390)) {
                        long l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.setStartValueDefault();
                    break;
                }
                case 499: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(33);
                    long l = this.readBigint();
                    numberSequence.setIncrement(l);
                    break;
                }
                case 226: {
                    this.read();
                    if (orderedIntHashSet.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 522) {
                        numberSequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 527) {
                        numberSequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 86) {
                        numberSequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 522: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMaxValueNoCheck(l);
                    break;
                }
                case 527: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMinValueNoCheck(l);
                    break;
                }
                case 86: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    numberSequence.setCycle(true);
                    break;
                }
                default: {
                    if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxDb2) && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    bl4 = true;
                }
            }
        } while (!bl4);
        numberSequence.checkValues();
    }

    private void readIndex(Table table, HsqlArrayList<Constraint> hsqlArrayList) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        hsqlName.schema = table.getSchemaName();
        hsqlName.parent = table.getName();
        hsqlName.schema = table.getSchemaName();
        if (this.readIfThis(374) && ("BTREE".equals(this.token.tokenString) || "HASH".equals(this.token.tokenString))) {
            this.read();
        }
        this.readThis(241);
        int[] nArray = this.readColumnList(table, true);
        Constraint constraint = new Constraint(hsqlName, table, nArray, 20);
        hsqlArrayList.add(constraint);
    }

    Boolean readIfNotExists() {
        Boolean bl = Boolean.FALSE;
        if (this.token.tokenType == 493) {
            int n = this.getPosition();
            this.read();
            if (this.token.tokenType == 229) {
                this.read();
                this.readThis(122);
                bl = Boolean.TRUE;
            } else {
                this.rewind(n);
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    StatementSchema compileAlterTableAddPeriod(Table table) {
        PeriodDefinition periodDefinition = this.readPeriod(table);
        if (periodDefinition.getPeriodType() != 1) {
            this.setPeriodColumns(table, periodDefinition);
            throw Error.error(1551);
        }
        this.checkPeriodColumnsAdd(table, periodDefinition);
        this.readThis(404);
        this.readIfThis(53);
        String string = periodDefinition.columnNames.get(0);
        if (!this.token.tokenString.equals(string)) {
            throw this.unexpectedToken();
        }
        HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (columnSchema.getSystemPeriodType() != 1) {
            throw Error.error(5516, columnSchema.getNameString());
        }
        this.readThis(404);
        this.readIfThis(53);
        this.checkIsSimpleName();
        string = periodDefinition.columnNames.get(1);
        if (!this.token.tokenString.equals(string)) {
            throw this.unexpectedToken();
        }
        hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema2 = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema2 == null) {
            throw Error.error(5000);
        }
        if (columnSchema2.getSystemPeriodType() != 2) {
            throw Error.error(5516, columnSchema2.getNameString());
        }
        periodDefinition.startColumn = columnSchema;
        periodDefinition.endColumn = columnSchema2;
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{table, periodDefinition};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string2, 115, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterTableDropPeriod(Table table) {
        if (!this.readIfThis(342)) {
            throw Error.error(1551);
        }
        PeriodDefinition periodDefinition = table.systemPeriod;
        if (periodDefinition == null) {
            throw Error.error(5517);
        }
        if (table.isSystemVersioned) {
            throw Error.error(5518);
        }
        boolean bl = this.readIfThis(417);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, periodDefinition, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 116, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterTableAddVersioning(Table table) {
        PeriodDefinition periodDefinition = table.systemPeriod;
        if (periodDefinition == null) {
            throw Error.error(5518);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 117, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterTableDropVersioning(Table table) {
        if (!table.isSystemVersioned) {
            throw Error.error(5518);
        }
        boolean bl = this.readIfThis(417);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 118, objectArray, null, hsqlNameArray);
    }
}

