/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.ExpressionArithmetic;
import shaded.org.hsqldb.ExpressionLogical;
import shaded.org.hsqldb.ExpressionOp;
import shaded.org.hsqldb.ExpressionValue;
import shaded.org.hsqldb.FunctionSQL;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.SortAndSlice;
import shaded.org.hsqldb.Tokens;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.IntKeyIntValueHashMap;
import shaded.org.hsqldb.lib.IntValueHashMap;
import shaded.org.hsqldb.lib.StringConverter;
import shaded.org.hsqldb.lib.StringUtil;
import shaded.org.hsqldb.lib.java.JavaSystem;
import shaded.org.hsqldb.map.BitMap;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.persist.Crypto;
import shaded.org.hsqldb.types.ArrayType;
import shaded.org.hsqldb.types.BinaryData;
import shaded.org.hsqldb.types.BinaryType;
import shaded.org.hsqldb.types.BlobData;
import shaded.org.hsqldb.types.CharacterType;
import shaded.org.hsqldb.types.ClobData;
import shaded.org.hsqldb.types.DateFormat;
import shaded.org.hsqldb.types.DateTimeType;
import shaded.org.hsqldb.types.HsqlDateTime;
import shaded.org.hsqldb.types.IntervalMonthData;
import shaded.org.hsqldb.types.IntervalSecondData;
import shaded.org.hsqldb.types.IntervalType;
import shaded.org.hsqldb.types.LobData;
import shaded.org.hsqldb.types.NumberFormat;
import shaded.org.hsqldb.types.NumberType;
import shaded.org.hsqldb.types.TimeData;
import shaded.org.hsqldb.types.TimestampData;
import shaded.org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASCIISTR = 75;
    private static final int FUNC_ASIN = 76;
    private static final int FUNC_ATAN = 77;
    private static final int FUNC_ATAN2 = 78;
    private static final int FUNC_BITAND = 79;
    private static final int FUNC_BITANDNOT = 80;
    private static final int FUNC_BITNOT = 81;
    private static final int FUNC_BITOR = 82;
    private static final int FUNC_BITXOR = 83;
    private static final int FUNC_CHAR = 84;
    private static final int FUNC_CONCAT = 85;
    private static final int FUNC_COS = 86;
    private static final int FUNC_COSH = 87;
    private static final int FUNC_COT = 88;
    private static final int FUNC_CURRENT_TIMEZONE = 89;
    private static final int FUNC_CRYPT_KEY = 90;
    private static final int FUNC_DATABASE = 91;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 92;
    private static final int FUNC_DATABASE_NAME = 93;
    private static final int FUNC_DATABASE_TIMEZONE = 94;
    private static final int FUNC_DATABASE_VERSION = 95;
    private static final int FUNC_DATE_ADD = 96;
    private static final int FUNC_DATE_SUB = 97;
    private static final int FUNC_DATEADD = 98;
    private static final int FUNC_DATEDIFF = 99;
    private static final int FUNC_DAYS = 100;
    private static final int FUNC_DBTIMEZONE = 101;
    private static final int FUNC_DEGREES = 102;
    private static final int FUNC_DIAGNOSTICS = 103;
    private static final int FUNC_DIFFERENCE = 104;
    private static final int FUNC_FROM_BASE64 = 105;
    private static final int FUNC_FROM_TZ = 106;
    private static final int FUNC_HEX = 107;
    private static final int FUNC_HEXTORAW = 108;
    private static final int FUNC_IDENTITY = 109;
    private static final int FUNC_INSTR = 110;
    private static final int FUNC_ISAUTOCOMMIT = 111;
    private static final int FUNC_ISOLATION_LEVEL = 112;
    private static final int FUNC_ISREADONLYDATABASE = 113;
    private static final int FUNC_ISREADONLYDATABASEFILES = 114;
    private static final int FUNC_ISREADONLYSESSION = 115;
    private static final int FUNC_LAST_DAY = 116;
    private static final int FUNC_LEFT = 117;
    private static final int FUNC_LOAD_FILE = 118;
    private static final int FUNC_LOB_ID = 119;
    private static final int FUNC_LOCATE = 120;
    private static final int FUNC_LOG10 = 121;
    private static final int FUNC_LPAD = 122;
    private static final int FUNC_LTRIM = 123;
    private static final int FUNC_MONTHS_BETWEEN = 124;
    private static final int FUNC_NEW_TIME = 125;
    private static final int FUNC_NEXT_DAY = 126;
    private static final int FUNC_NUMTODSINTERVAL = 127;
    private static final int FUNC_NUMTOYMINTERVAL = 128;
    private static final int FUNC_PI = 129;
    private static final int FUNC_POSITION_ARRAY = 130;
    private static final int FUNC_RADIANS = 131;
    private static final int FUNC_RAND = 132;
    private static final int FUNC_RAWTOHEX = 133;
    private static final int FUNC_REGEXP_COUNT = 134;
    private static final int FUNC_REGEXP_INSTR = 135;
    private static final int FUNC_REGEXP_LIKE = 136;
    private static final int FUNC_REGEXP_MATCHES = 137;
    private static final int FUNC_REGEXP_REPLACE = 138;
    private static final int FUNC_REGEXP_SUBSTR = 139;
    private static final int FUNC_REGEXP_SUBSTRING = 140;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 141;
    private static final int FUNC_REPEAT = 142;
    private static final int FUNC_REPLACE = 143;
    private static final int FUNC_REVERSE = 144;
    private static final int FUNC_RIGHT = 145;
    private static final int FUNC_ROUND = 146;
    private static final int FUNC_ROUNDMAGIC = 147;
    private static final int FUNC_RPAD = 148;
    private static final int FUNC_RTRIM = 149;
    private static final int FUNC_SECONDS_MIDNIGHT = 150;
    private static final int FUNC_SEQUENCE_ARRAY = 151;
    private static final int FUNC_SESSION_ID = 152;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 153;
    private static final int FUNC_SESSION_TIMEZONE = 154;
    private static final int FUNC_SESSIONTIMEZONE = 155;
    private static final int FUNC_SIGN = 156;
    private static final int FUNC_SIN = 157;
    private static final int FUNC_SINH = 158;
    private static final int FUNC_SOUNDEX = 159;
    private static final int FUNC_SORT_ARRAY = 160;
    private static final int FUNC_SPACE = 161;
    private static final int FUNC_SUBSTR = 162;
    private static final int FUNC_SYS_EXTRACT_UTC = 163;
    private static final int FUNC_SYS_GUID = 164;
    private static final int FUNC_SYSDATE = 165;
    private static final int FUNC_SYSTIMESTAMP = 166;
    private static final int FUNC_TAN = 167;
    private static final int FUNC_TANH = 168;
    private static final int FUNC_TIMESTAMP = 169;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 170;
    private static final int FUNC_TIMESTAMPADD = 171;
    private static final int FUNC_TIMESTAMPDIFF = 172;
    private static final int FUNC_TIMEZONE = 173;
    private static final int FUNC_TO_BASE64 = 174;
    private static final int FUNC_TO_CHAR = 175;
    private static final int FUNC_TO_DATE = 176;
    private static final int FUNC_TO_DSINTERVAL = 177;
    private static final int FUNC_TO_YMINTERVAL = 178;
    private static final int FUNC_TO_NUMBER = 179;
    private static final int FUNC_TO_TIMESTAMP = 180;
    private static final int FUNC_TO_TIMESTAMP_TZ = 181;
    private static final int FUNC_TRANSACTION_CONTROL = 182;
    private static final int FUNC_TRANSACTION_ID = 183;
    private static final int FUNC_TRANSACTION_SIZE = 184;
    private static final int FUNC_TRANSACTION_UTC = 185;
    private static final int FUNC_TRANSLATE = 186;
    private static final int FUNC_TRUNC = 187;
    private static final int FUNC_TRUNCATE = 188;
    private static final int FUNC_UNHEX = 189;
    private static final int FUNC_UNISTR = 190;
    private static final int FUNC_UUID = 191;
    private static final int FUNC_UNIX_TIMESTAMP = 192;
    private static final int FUNC_UNIX_MILLIS = 193;
    private static final int FUNC_DATEPART = 194;
    private static final int FUNC_DATENAME = 195;
    private static final int FUNC_NANVL = 196;
    private static final int FUNC_SQLCODE = 197;
    private static final int FUNC_SQLERRM = 198;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private DateTimeFormatter dateTimeFormatter;
    private IntKeyIntValueHashMap charLookup;
    private static IntValueHashMap tsiTokensForStringPart;
    private static IntKeyIntValueHashMap tokensForTSIPart;
    private static IntValueHashMap sqlTypeForToken;

    public static FunctionSQL newCustomFunction(Session session, String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 199: 
            case 515: 
            case 617: 
            case 712: 
            case 756: 
            case 839: {
                return new FunctionSQL(n2);
            }
            case 642: 
            case 645: 
            case 750: 
            case 821: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 804: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                functionSQL.name = "SUBSTR";
                return functionSQL;
            }
            case 653: 
            case 654: 
            case 678: 
            case 745: {
                if (session.database.sqlSyntaxMss) break;
                return null;
            }
            case 667: 
            case 809: 
            case 811: {
                if (session.database.sqlSyntaxOra) break;
                return null;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 204: {
                    functionCustom.extractSpec = 188;
                    break;
                }
                case 302: {
                    functionCustom.extractSpec = 354;
                    break;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 658: {
                    functionCustom.extractSpec = 663;
                    break;
                }
                case 737: {
                    functionCustom.extractSpec = 739;
                    break;
                }
                case 659: {
                    functionCustom.extractSpec = 664;
                    break;
                }
                case 660: {
                    functionCustom.extractSpec = 665;
                    break;
                }
                case 661: {
                    functionCustom.extractSpec = 666;
                    break;
                }
                case 849: {
                    functionCustom.extractSpec = 850;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 101: 
            case 154: 
            case 155: 
            case 165: 
            case 166: 
            case 197: 
            case 198: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 129: 
            case 152: 
            case 153: 
            case 164: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 119: 
            case 121: 
            case 131: 
            case 133: 
            case 144: 
            case 147: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 161: 
            case 163: 
            case 167: 
            case 168: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 189: 
            case 190: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 90: 
            case 104: 
            case 106: 
            case 117: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 145: 
            case 196: {
                this.parseList = doubleParamList;
                break;
            }
            case 118: 
            case 146: 
            case 169: 
            case 175: 
            case 176: 
            case 180: 
            case 181: 
            case 187: 
            case 188: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 99: {
                this.parseList = new short[]{926, 975, 913, 928, 913, 928, 911};
                this.parseListAlt = new short[]{926, 928, 913, 928, 972, 2, 913, 928, 911};
                break;
            }
            case 98: {
                this.parseList = new short[]{926, 975, 913, 928, 913, 928, 911};
                this.parseListAlt = tripleParamList;
                break;
            }
            case 194: 
            case 195: {
                this.parseList = new short[]{926, 975, 913, 928, 911};
                break;
            }
            case 96: 
            case 97: {
                this.parseList = doubleParamList;
                break;
            }
            case 151: 
            case 186: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 122: 
            case 143: 
            case 148: {
                this.parseList = new short[]{926, 928, 913, 928, 972, 2, 913, 928, 911};
                break;
            }
            case 138: {
                this.parseList = new short[]{926, 928, 913, 928, 972, 2, 913, 928, 972, 2, 913, 928, 972, 2, 913, 928, 972, 2, 913, 928, 911};
                break;
            }
            case 191: 
            case 192: 
            case 193: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 109: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 103: {
                this.parseList = new short[]{926, 599, 911};
                break;
            }
            case 130: {
                this.parseList = new short[]{926, 928, 154, 928, 972, 2, 137, 928, 911};
                break;
            }
            case 160: {
                this.parseList = new short[]{926, 928, 972, 4, 971, 2, 408, 462, 972, 5, 542, 971, 2, 479, 514, 911};
                break;
            }
            case 171: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{926, 971, 22, 890, 892, 891, 893, 894, 895, 896, 897, 898, 899, 900, 743, 732, 734, 308, 215, 151, 88, 849, 219, 764, 393, 913, 928, 913, 928, 911};
                break;
            }
            case 172: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{926, 971, 22, 890, 892, 891, 893, 894, 895, 896, 897, 898, 899, 900, 743, 732, 734, 308, 215, 151, 88, 849, 219, 764, 393, 913, 928, 913, 928, 911};
                break;
            }
            case 132: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    expressionArray2[0] = expressionArray[0];
                    expressionArray2[1] = expressionArray[1];
                    expressionArray2[3] = expressionArray[2];
                    expressionArray = expressionArray2;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                expressionArray2[0] = expressionArray[1];
                expressionArray2[1] = expressionArray[0];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[1] == null ? new ExpressionValue(" ", Type.SQL_CHAR) : expressionArray[1], expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 85: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 197: {
                return 0;
            }
            case 198: {
                return "Error";
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 91: {
                return session.getDatabase().getPath();
            }
            case 93: {
                return session.getDatabase().getNameString();
            }
            case 111: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 115: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 113: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 114: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 112: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 153: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 92: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 182: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 173: {
                TimestampData timestampData = DateTimeType.newCurrentTimestamp(session.currentTimeZone);
                return new IntervalSecondData(timestampData.getZone(), 0);
            }
            case 154: {
                TimestampData timestampData = DateTimeType.newCurrentTimestamp(session.timeZone);
                return new IntervalSecondData(timestampData.getZone(), 0);
            }
            case 101: {
                int n = HsqlDateTime.getZoneSeconds();
                IntervalSecondData intervalSecondData = new IntervalSecondData(n, 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 94: {
                int n = HsqlDateTime.getZoneSeconds();
                return new IntervalSecondData(n, 0);
            }
            case 95: {
                return "2.7.3";
            }
            case 152: {
                return session.getId();
            }
            case 72: {
                return session.actionSCN;
            }
            case 183: {
                return session.transactionSCN;
            }
            case 184: {
                return (long)session.getTransactionSize();
            }
            case 185: {
                return session.getTransactionUTC();
            }
            case 119: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 109: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 103: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 151: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList<Object> hsqlArrayList = new HsqlArrayList<Object>();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(session, object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 171: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 743: 
                    case 890: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 732: 
                    case 892: {
                        long l3 = l / 1000000L;
                        int n3 = (int)(l % 1000000L) * 1000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 734: 
                    case 891: {
                        long l4 = l / 1000L;
                        int n4 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l4, n4, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 308: 
                    case 893: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 215: 
                    case 894: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 151: 
                    case 895: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 88: 
                    case 665: 
                    case 666: 
                    case 896: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 849: 
                    case 897: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 219: 
                    case 898: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 764: 
                    case 899: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 393: 
                    case 900: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 172: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                switch (n) {
                    case 743: 
                    case 890: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos();
                    }
                    case 732: 
                    case 892: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000);
                    }
                    case 734: 
                    case 891: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000);
                    }
                    case 308: 
                    case 893: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 215: 
                    case 894: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 151: 
                    case 895: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 88: 
                    case 896: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 849: 
                    case 897: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 6L) / 7L : (l + 6L) / 7L;
                        return l;
                    }
                    case 219: 
                    case 898: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 764: 
                    case 899: {
                        DateTimeType dateTimeType = (DateTimeType)this.nodes[1].getDataType();
                        timestampData = (TimestampData)dateTimeType.truncate(session, timestampData, 127);
                        timestampData2 = (TimestampData)dateTimeType.truncate(session, timestampData2, 127);
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        return l /= 3L;
                    }
                    case 393: 
                    case 900: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 195: {
                Object object = this.getExtractValue(session, objectArray);
                return this.dataType.convertToDefaultType(session, object);
            }
            case 96: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.add(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 97: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 100: {
                if (objectArray[0] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, objectArray[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(intervalSecondData.getSeconds() / 86400L + 1L));
            }
            case 129: {
                return Math.PI;
            }
            case 132: {
                if (this.nodes[0] == null) {
                    return session.random();
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return session.random(l);
            }
            case 146: 
            case 187: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 146 ? dateTimeType.round(session, objectArray[0], n) : dateTimeType.truncate(session, objectArray[0], n);
                }
            }
            case 188: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 146 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 105: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                string = string.trim();
                byte[] byArray = Base64.getDecoder().decode(string);
                return new BinaryData(byArray, false);
            }
            case 174: {
                BinaryData binaryData = (BinaryData)objectArray[0];
                if (binaryData == null) {
                    return null;
                }
                return Base64.getEncoder().encodeToString(binaryData.getBytes());
            }
            case 175: {
                if (this.nodes[1] == null) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.dateTimeFormatter == null) {
                    if (this.nodes[0].dataType.isDateTimeType()) {
                        return DateFormat.toFormattedDate((DateTimeType)this.nodes[0].dataType, objectArray[0], (String)objectArray[1]);
                    }
                    NumberFormat numberFormat = new NumberFormat((String)objectArray[1]);
                    return numberFormat.format((Number)objectArray[0]);
                }
                return DateFormat.toFormattedDate((DateTimeType)this.nodes[0].dataType, objectArray[0], this.dateTimeFormatter);
            }
            case 179: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 176: 
            case 180: 
            case 181: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateOrTimestampType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                TimestampData timestampData = this.dateTimeFormatter == null ? DateFormat.toDate((DateTimeType)this.dataType, (String)objectArray[0], (String)objectArray[1]) : DateFormat.toDate((DateTimeType)this.dataType, (String)objectArray[0], this.dateTimeFormatter);
                return timestampData;
            }
            case 169: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        Calendar calendar = session.getCalendar();
                        long l = ((Number)objectArray[0]).longValue();
                        calendar.setTimeInMillis(l * 1000L);
                        int n = HsqlDateTime.getZoneSeconds(calendar);
                        return new TimestampData(l + (long)n);
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException hsqlException) {
                        return Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME_MAX.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 170: {
                long l;
                Calendar calendar = session.getCalendar();
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    l = ((Number)objectArray[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                    l = HsqlDateTime.convertMillisToCalendar(calendar, l * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)objectArray[1]);
                }
                calendar.setTimeInMillis(l * 1000L);
                int n5 = HsqlDateTime.getZoneSeconds(calendar);
                return new TimestampData(l, n, n5);
            }
            case 164: {
                UUID uUID = UUID.randomUUID();
                long l = uUID.getMostSignificantBits();
                long l5 = uUID.getLeastSignificantBits();
                return new BinaryData(ArrayUtil.toByteArray(l, l5), false);
            }
            case 191: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l6 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l6), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    if (this.dataType.isBinaryType()) {
                        byte[] byArray = StringConverter.toBinaryUUID((String)objectArray[0]);
                        return new BinaryData(byArray, false);
                    }
                    return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
                }
                catch (NumberFormatException numberFormatException) {
                    throw Error.error(3459, numberFormatException);
                }
            }
            case 193: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp();
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                long l = timestampData.getSeconds() * 1000L + (long)(timestampData.getNanos() / 1000000);
                return l;
            }
            case 192: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp();
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                return timestampData.getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (session.database.sqlDoubleNaN && (d > 1.0 || d < -1.0)) {
                    throw Error.error(3403);
                }
                return Math.acos(d);
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (session.database.sqlDoubleNaN && (d > 1.0 || d < -1.0)) {
                    throw Error.error(3403);
                }
                return Math.asin(d);
            }
            case 77: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.atan(d);
            }
            case 86: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cos(d);
            }
            case 87: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cosh(d);
            }
            case 88: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return d2;
            }
            case 102: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toDegrees(d);
            }
            case 157: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sin(d);
            }
            case 158: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sinh(d);
            }
            case 167: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tan(d);
            }
            case 168: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tanh(d);
            }
            case 121: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (d < 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                return Math.log10(d);
            }
            case 131: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toRadians(d);
            }
            case 156: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (session.database.sqlSyntaxOra && objectArray[0] instanceof Double && (Double)objectArray[0] == 0.0) {
                    return 1;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return n;
            }
            case 78: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return Math.atan2(d, d3);
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.isEmpty()) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                return StringConverter.stringToUnicodeEscaped(string);
            }
            case 84: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 147: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 159: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long l = 0L;
                    long l7 = 0L;
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    long l8 = ((Number)objectArray[0]).longValue();
                    if (this.funcType != 81) {
                        objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                        l7 = ((Number)objectArray[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 79: {
                            l = l8 & l7;
                            break;
                        }
                        case 80: {
                            l = l8 & (l7 ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 81: {
                            l = l8 ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 82: {
                            l = l8 | l7;
                            break;
                        }
                        case 83: {
                            l = l8 ^ l7;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)l);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = null;
                if (this.funcType != 81) {
                    byArray3 = ((BinaryData)objectArray[1]).getBytes();
                }
                switch (this.funcType) {
                    case 79: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 80: {
                        byArray3 = BitMap.not(byArray3);
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 81: {
                        byArray = BitMap.not(byArray2);
                        break;
                    }
                    case 82: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 83: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 104: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                int n6 = 1;
                block178: for (int i = 1; i < 4; ++i) {
                    for (int j = n6; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        n6 = j + 1;
                        continue block178;
                    }
                }
                return ValuePool.getInt(n);
            }
            case 107: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isBinaryType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    long l = ((Number)objectArray[0]).longValue();
                    return Long.toHexString(l);
                }
                String string = (String)objectArray[0];
                byte[] byArray = string.getBytes(JavaSystem.CS_ISO_8859_1);
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 190: {
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    return StringConverter.unicodeEscapedToString((String)objectArray[0]);
                }
                catch (Throwable throwable) {
                    throw Error.error(throwable, 5586, null);
                }
            }
            case 108: 
            case 189: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 133: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 142: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuilder stringBuilder = new StringBuilder(string.length() * n);
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case 143: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                if (string2.isEmpty()) {
                    return string;
                }
                while (true) {
                    int n7;
                    if ((n7 = string.indexOf(string2, n)) == -1) break;
                    stringBuilder.append(string, n, n7).append(string3);
                    n = n7 + string2.length();
                }
                stringBuilder.append(string.substring(n));
                return stringBuilder.toString();
            }
            case 117: 
            case 145: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = 0;
                int n8 = ((Number)objectArray[1]).intValue();
                boolean bl = true;
                boolean bl3 = false;
                if (this.funcType == 145) {
                    n = n8;
                    n8 = 0;
                    bl = false;
                    bl3 = true;
                }
                return ((CharacterType)this.dataType).substring(session, objectArray[0], n, n8, bl, bl3);
            }
            case 161: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 144: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder((String)objectArray[0]);
                stringBuilder = stringBuilder.reverse();
                return stringBuilder.toString();
            }
            case 138: {
                String string;
                int n;
                for (n = 0; n < this.nodes.length && this.nodes[n] != null; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = FunctionCustom.regexpParams((String)objectArray[5]);
                String string4 = (String)objectArray[0];
                String string5 = (String)objectArray[1];
                String string6 = (String)objectArray[2];
                int n9 = 1;
                int n10 = 0;
                if (this.nodes[2] == null) {
                    string6 = "";
                }
                if (this.nodes[3] != null && ((n9 = ((Number)objectArray[3]).intValue()) < 1 || n9 >= string4.length())) {
                    throw Error.error(3403);
                }
                if (this.nodes[4] != null && (n10 = ((Number)objectArray[4]).intValue()) < 0) {
                    throw Error.error(3403);
                }
                Pattern pattern = this.pattern == null ? Pattern.compile(string5) : this.pattern;
                Matcher matcher = pattern.matcher(string4);
                if (n9 > 1) {
                    matcher.region(n9 - 1, string4.length());
                }
                if (n10 == 0) {
                    string = matcher.replaceAll(string6);
                } else if (n10 == 1) {
                    string = matcher.replaceFirst(string6);
                } else {
                    throw Error.error(3472, "count");
                }
                return string;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string7 = (String)objectArray[1];
                Pattern pattern = this.pattern == null ? Pattern.compile(string7) : this.pattern;
                Matcher matcher = pattern.matcher(string);
                switch (this.funcType) {
                    case 136: 
                    case 137: {
                        boolean bl = matcher.matches();
                        return bl;
                    }
                    case 135: {
                        boolean bl = matcher.find();
                        if (bl) {
                            return matcher.start() + 1;
                        }
                        return ValuePool.INTEGER_0;
                    }
                    case 139: 
                    case 140: {
                        boolean bl = matcher.find();
                        if (bl) {
                            return matcher.group();
                        }
                        return null;
                    }
                    case 134: {
                        int n = 0;
                        while (matcher.find()) {
                            ++n;
                        }
                        return n;
                    }
                    case 141: {
                        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
                        while (matcher.find()) {
                            hsqlArrayList.add(matcher.group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 90: {
                byte[] byArray = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 118: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string);
            }
            case 122: 
            case 148: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, objectArray[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]));
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string8 = " ";
                if (this.nodes[2] != null && (string8 = this.nodes[2].dataType.convertToString(objectArray[2])).isEmpty()) {
                    string8 = " ";
                }
                string = (String)Type.SQL_VARCHAR.trim(session, string, ' ', true, true);
                string = StringUtil.toPaddedString(string, n, string8, this.funcType == 148);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string, Type.SQL_VARCHAR);
                }
                return string;
            }
            case 130: {
                if (objectArray[1] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = 1;
                if (this.nodes[2] != null) {
                    if (objectArray[2] == null) {
                        return null;
                    }
                    n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                }
                if (n < 1) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 160: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 462;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 514;
                Object[] objectArray4 = (Object[])ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, objectArray4, sortAndSlice);
                return objectArray4;
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, timestampData, n);
            }
            case 106: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                if (DateTimeType.zoneIDs.contains(objectArray[1])) {
                    return ((DateTimeType)this.dataType).changeZone(session, timestampData, (String)objectArray[1]);
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                return new TimestampData(timestampData.getSeconds() + (long)timestampData.getZone() - intervalSecondData.getSeconds(), timestampData.getNanos(), (int)intervalSecondData.getSeconds());
            }
            case 116: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, objectArray[0]);
            }
            case 124: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)objectArray[0], (TimestampData)objectArray[1]);
            }
            case 196: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (Double.isNaN(d)) {
                    return this.dataType.convertToType(session, objectArray[1], this.nodes[1].dataType);
                }
                return objectArray[0];
            }
            case 126: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                int n = DateTimeType.getDayOfWeek((String)objectArray[1]);
                return DateTimeType.nextDayOfWeek(session, timestampData, n);
            }
            case 127: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n11 = IntervalType.getFieldNameTypeForToken(n);
                switch (n11) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalSecondData.newInterval(d, n11);
            }
            case 128: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n12 = IntervalType.getFieldNameTypeForToken(n);
                switch (n12) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalMonthData.newInterval(d, n12);
            }
            case 155: {
                IntervalSecondData intervalSecondData = new IntervalSecondData(session.getZoneSeconds(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 163: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(session, objectArray[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, false);
            }
            case 165: {
                TimestampData timestampData = DateTimeType.newSysDateTimestamp();
                return this.dataType.convertToType(session, timestampData, Type.SQL_TIMESTAMP);
            }
            case 166: {
                return DateTimeType.newSystemTimestampWithZone();
            }
            case 177: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 178: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 186: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap intKeyIntValueHashMap = this.charLookup;
                if (intKeyIntValueHashMap == null) {
                    intKeyIntValueHashMap = FunctionCustom.getTranslationMap((String)objectArray[1], (String)objectArray[2]);
                }
                return FunctionCustom.translateWithMap((String)objectArray[0], intKeyIntValueHashMap);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 197: {
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 198: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression);
                return;
            }
            case 91: 
            case 93: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 111: 
            case 113: 
            case 114: 
            case 115: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 92: 
            case 95: 
            case 112: 
            case 153: 
            case 182: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 94: 
            case 154: 
            case 173: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 109: 
            case 119: 
            case 152: 
            case 183: 
            case 184: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 103: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 151: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[0].dataType.typeCode != this.nodes[1].dataType.typeCode) {
                        throw Error.error(5562);
                    }
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 98: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 171;
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 171: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.typeCode == 91) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                    switch (n) {
                        case 151: 
                        case 215: 
                        case 308: 
                        case 732: 
                        case 734: 
                        case 743: 
                        case 890: 
                        case 891: 
                        case 893: 
                        case 894: 
                        case 895: {
                            this.dataType = Type.SQL_TIMESTAMP;
                        }
                    }
                }
                return;
            }
            case 99: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(896), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 172;
            }
            case 172: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType.isCharacterType()) {
                    if (this.nodes[1].opType == 1 && this.nodes[1].valueData != null) {
                        TimestampData timestampData = session.getScanner().newTimestamp((String)this.nodes[1].valueData);
                        this.nodes[1].valueData = timestampData;
                        this.nodes[1].dataType = session.getScanner().dateTimeType;
                    } else {
                        this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                    }
                }
                if (this.nodes[2].dataType.isCharacterType()) {
                    if (this.nodes[2].opType == 1 && this.nodes[2].valueData != null) {
                        TimestampData timestampData = session.getScanner().newTimestamp((String)this.nodes[2].valueData);
                        this.nodes[2].valueData = timestampData;
                        this.nodes[2].dataType = session.getScanner().dateTimeType;
                    } else {
                        this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                    }
                }
                block78 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                            this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 896: 
                            case 897: 
                            case 898: 
                            case 899: 
                            case 900: {
                                break block78;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (!this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    case 95: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 194: {
                if (this.extractSpec != 0) {
                    return;
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.funcType = 5;
                super.resolveTypes(session, expression);
                return;
            }
            case 195: {
                if (this.extractSpec != 0) {
                    return;
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                if (this.extractSpec == 665) {
                    this.extractSpec = 663;
                } else if (this.extractSpec == 219) {
                    this.extractSpec = 739;
                }
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 96: 
            case 97: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 100: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 146: 
            case 187: {
                int n2;
                int n3 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        if (expression instanceof ExpressionLogical || expression instanceof ExpressionArithmetic) {
                            for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                                if (expression.nodes[n2].dataType == null) continue;
                                this.nodes[0].dataType = expression.nodes[n2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0) {
                        String string;
                        int n4;
                        if (!this.nodes[1].dataType.isCharacterType()) {
                            throw Error.error(5566);
                        }
                        if (this.nodes[1].opType == 1 && (n4 = HsqlDateTime.toStandardIntervalPart(string = (String)this.nodes[1].valueData)) < 0) {
                            throw Error.error(5566, string);
                        }
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 188: {
                int n2;
                Number number = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number != null) {
                    n2 = number;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > this.dataType.scale) {
                        n2 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n2 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n2, n2);
                    }
                }
                return;
            }
            case 175: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[0].dataType.isDateTimeType() && !this.nodes[0].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1 && this.nodes[1].valueData != null && this.nodes[0].dataType.isDateTimeType()) {
                        this.dateTimeFormatter = DateFormat.toFormatter((String)this.nodes[1].valueData, false);
                    }
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 179: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 176: 
            case 180: 
            case 181: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = this.funcType == 176 ? "DD-MON-YYYY HH24:MI:SS" : (this.funcType == 180 ? "DD-MON-YYYY HH24:MI:SS.FF" : "DD-MON-YYYY HH24:MI:SS:FFTZ");
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    if (this.nodes[1].opType == 1 && this.nodes[1].valueData != null) {
                        this.dateTimeFormatter = DateFormat.toFormatter((String)this.nodes[1].valueData, true);
                    }
                } else if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 176 ? Type.SQL_TIMESTAMP_NO_FRACTION : (this.funcType == 180 ? Type.SQL_TIMESTAMP : Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                return;
            }
            case 169: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME_MAX;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 170: {
                Type type = this.nodes[0].dataType;
                if (type == null) {
                    type = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 129: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 164: {
                this.dataType = Type.SQL_BINARY_16;
                break;
            }
            case 191: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_UUID;
                    break;
                }
                throw Error.error(5563);
            }
            case 192: 
            case 193: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 132: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 76: 
            case 77: 
            case 86: 
            case 87: 
            case 88: 
            case 102: 
            case 121: 
            case 131: 
            case 147: 
            case 157: 
            case 158: 
            case 167: 
            case 168: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 156: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 78: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 159: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (this.funcType == 81) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = this.nodes[1].dataType;
                    }
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (n = 0; n < this.nodes.length; ++n) {
                        if (this.nodes[n].dataType != null) continue;
                        this.nodes[n].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 14: 
                    case 15: 
                    case 25: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 75: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 84: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 105: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision * 3L / 4L);
                break;
            }
            case 190: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 108: 
            case 189: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 174: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].dataType.precision == 0L) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                long l = (this.nodes[0].dataType.precision + 2L) / 3L * 4L;
                this.dataType = CharacterType.getCharacterType(12, l);
                break;
            }
            case 107: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 133: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 142: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 143: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 117: 
            case 145: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 161: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].opType == 1 && this.nodes[1].valueData != null) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 134: 
                    case 135: {
                        this.dataType = Type.SQL_INTEGER;
                        break block0;
                    }
                    case 136: 
                    case 137: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break block0;
                    }
                    case 138: 
                    case 139: 
                    case 140: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 141: {
                        this.dataType = Type.getDefaultArrayType(12);
                        break block0;
                    }
                }
                break;
            }
            case 90: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 118: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 122: 
            case 148: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                break;
            }
            case 130: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType.collectionBaseType();
                }
                if (!this.nodes[1].dataType.collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_INTEGER;
                    }
                    if (!this.nodes[2].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 160: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(408), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(479), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 101: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 106: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP_NO_FRACTION);
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 124: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 196: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_DOUBLE);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 127: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 128: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 155: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 163: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 165: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 166: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 177: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 178: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 185: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 186: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[n].dataType.isCharacterType() && !this.nodes[n].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = FunctionCustom.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuilder.append(",").append(this.nodes[3].getSQL());
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 122: 
            case 148: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.name).append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(",").append(this.nodes[2].getSQL());
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 130: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.name).append('(').append(this.nodes[0].getSQL()).append(' ').append("IN").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 160: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.name).append('(').append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 462) {
                    stringBuilder.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 514) {
                    stringBuilder.append(' ').append("NULLS").append(' ').append("LAST");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 165: 
            case 166: {
                return this.name;
            }
            case 72: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 129: 
            case 152: 
            case 153: 
            case 154: 
            case 164: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.name).append("(").append(")");
                return stringBuilder.toString();
            }
            case 171: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append("TIMESTAMPADD").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")");
                return stringBuilder.toString();
            }
            case 172: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append("TIMESTAMPDIFF").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")");
                return stringBuilder.toString();
            }
            case 96: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.nodes[0].getSQL()).append(' ').append('+').append(this.nodes[1].getSQL());
                return stringBuilder.toString();
            }
            case 97: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.nodes[0].getSQL()).append(' ').append('-').append(this.nodes[1].getSQL());
                return stringBuilder.toString();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 161: 
            case 163: 
            case 167: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: {
                return this.getSQLSimple();
            }
            case 103: {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(this.name).append('(').append("ROW_COUNT").append(')');
                return stringBuilder.toString();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
        boolean bl = false;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.nodes[i].getSQL());
            bl = true;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    private static int getTSIToken(String string) {
        int n = tsiTokensForStringPart.get((Object)string.toLowerCase(Locale.ENGLISH), -1);
        if (n == -1) {
            throw Error.error(5566, string);
        }
        return n;
    }

    private static int getExtractTokenForTSIPart(int n) {
        int n2 = tokensForTSIPart.get(n, -1);
        if (n2 == -1) {
            throw Error.runtimeError(201, "FunctionCustom");
        }
        return n2;
    }

    static int getSQLTypeForToken(String string) {
        int n = sqlTypeForToken.get((Object)string.toUpperCase(Locale.ENGLISH), -1);
        return n;
    }

    private static IntKeyIntValueHashMap getTranslationMap(String string, String string2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = new IntKeyIntValueHashMap();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i >= string2.length()) {
                intKeyIntValueHashMap.put(c, -1);
                continue;
            }
            char c2 = string2.charAt(i);
            intKeyIntValueHashMap.put(c, c2);
        }
        return intKeyIntValueHashMap;
    }

    private static String translateWithMap(String string, IntKeyIntValueHashMap intKeyIntValueHashMap) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = intKeyIntValueHashMap.get((int)c, -2);
            if (n == -2) {
                stringBuilder.append(c);
                continue;
            }
            if (n == -1) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static int regexpParams(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 2;
                    continue block6;
                }
                case 'c': {
                    n &= 0xFFFFFFFD;
                    n |= 0x40;
                    continue block6;
                }
                case 'n': {
                    n |= 0x20;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                default: {
                    throw Error.error(3472, string);
                }
            }
        }
        return n;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(91);
        nonDeterministicFuncSet.add(92);
        nonDeterministicFuncSet.add(94);
        nonDeterministicFuncSet.add(101);
        nonDeterministicFuncSet.add(109);
        nonDeterministicFuncSet.add(111);
        nonDeterministicFuncSet.add(115);
        nonDeterministicFuncSet.add(113);
        nonDeterministicFuncSet.add(114);
        nonDeterministicFuncSet.add(112);
        nonDeterministicFuncSet.add(152);
        nonDeterministicFuncSet.add(153);
        nonDeterministicFuncSet.add(154);
        nonDeterministicFuncSet.add(155);
        nonDeterministicFuncSet.add(164);
        nonDeterministicFuncSet.add(165);
        nonDeterministicFuncSet.add(166);
        nonDeterministicFuncSet.add(169);
        nonDeterministicFuncSet.add(173);
        nonDeterministicFuncSet.add(182);
        nonDeterministicFuncSet.add(183);
        nonDeterministicFuncSet.add(184);
        nonDeterministicFuncSet.add(185);
        nonDeterministicFuncSet.add(191);
        nonDeterministicFuncSet.add(192);
        nonDeterministicFuncSet.add(193);
        customRegularFuncMap.put(3, 71);
        customRegularFuncMap.put(600, 72);
        customRegularFuncMap.put(601, 73);
        customRegularFuncMap.put(604, 160);
        customRegularFuncMap.put(605, 74);
        customRegularFuncMap.put(606, 75);
        customRegularFuncMap.put(16, 76);
        customRegularFuncMap.put(19, 77);
        customRegularFuncMap.put(607, 78);
        customRegularFuncMap.put(615, 79);
        customRegularFuncMap.put(616, 80);
        customRegularFuncMap.put(617, 6);
        customRegularFuncMap.put(618, 81);
        customRegularFuncMap.put(619, 82);
        customRegularFuncMap.put(620, 83);
        customRegularFuncMap.put(42, 84);
        customRegularFuncMap.put(629, 84);
        customRegularFuncMap.put(636, 85);
        customRegularFuncMap.put(64, 86);
        customRegularFuncMap.put(65, 87);
        customRegularFuncMap.put(640, 88);
        customRegularFuncMap.put(641, 90);
        customRegularFuncMap.put(642, 43);
        customRegularFuncMap.put(643, 154);
        customRegularFuncMap.put(645, 51);
        customRegularFuncMap.put(646, 91);
        customRegularFuncMap.put(648, 93);
        customRegularFuncMap.put(647, 92);
        customRegularFuncMap.put(649, 94);
        customRegularFuncMap.put(650, 95);
        customRegularFuncMap.put(656, 96);
        customRegularFuncMap.put(657, 97);
        customRegularFuncMap.put(651, 98);
        customRegularFuncMap.put(652, 99);
        customRegularFuncMap.put(653, 195);
        customRegularFuncMap.put(654, 194);
        customRegularFuncMap.put(88, 5);
        customRegularFuncMap.put(658, 5);
        customRegularFuncMap.put(659, 5);
        customRegularFuncMap.put(660, 5);
        customRegularFuncMap.put(661, 5);
        customRegularFuncMap.put(662, 100);
        customRegularFuncMap.put(667, 101);
        customRegularFuncMap.put(671, 102);
        customRegularFuncMap.put(464, 103);
        customRegularFuncMap.put(673, 104);
        customRegularFuncMap.put(678, 116);
        customRegularFuncMap.put(685, 105);
        customRegularFuncMap.put(686, 106);
        customRegularFuncMap.put(692, 107);
        customRegularFuncMap.put(693, 108);
        customRegularFuncMap.put(151, 5);
        customRegularFuncMap.put(152, 109);
        customRegularFuncMap.put(160, 32);
        customRegularFuncMap.put(700, 1);
        customRegularFuncMap.put(706, 111);
        customRegularFuncMap.put(707, 113);
        customRegularFuncMap.put(708, 114);
        customRegularFuncMap.put(709, 115);
        customRegularFuncMap.put(704, 112);
        customRegularFuncMap.put(711, 116);
        customRegularFuncMap.put(712, 26);
        customRegularFuncMap.put(191, 117);
        customRegularFuncMap.put(515, 7);
        customRegularFuncMap.put(717, 118);
        customRegularFuncMap.put(719, 119);
        customRegularFuncMap.put(720, 1);
        customRegularFuncMap.put(199, 14);
        customRegularFuncMap.put(200, 121);
        customRegularFuncMap.put(203, 122);
        customRegularFuncMap.put(204, 31);
        customRegularFuncMap.put(215, 5);
        customRegularFuncMap.put(219, 5);
        customRegularFuncMap.put(737, 5);
        customRegularFuncMap.put(738, 124);
        customRegularFuncMap.put(744, 196);
        customRegularFuncMap.put(745, 191);
        customRegularFuncMap.put(748, 126);
        customRegularFuncMap.put(752, 127);
        customRegularFuncMap.put(753, 128);
        customRegularFuncMap.put(756, 8);
        customRegularFuncMap.put(760, 129);
        customRegularFuncMap.put(761, 130);
        customRegularFuncMap.put(764, 5);
        customRegularFuncMap.put(765, 131);
        customRegularFuncMap.put(766, 132);
        customRegularFuncMap.put(768, 133);
        customRegularFuncMap.put(771, 134);
        customRegularFuncMap.put(772, 135);
        customRegularFuncMap.put(773, 136);
        customRegularFuncMap.put(774, 137);
        customRegularFuncMap.put(775, 138);
        customRegularFuncMap.put(776, 139);
        customRegularFuncMap.put(777, 140);
        customRegularFuncMap.put(778, 141);
        customRegularFuncMap.put(289, 142);
        customRegularFuncMap.put(781, 143);
        customRegularFuncMap.put(783, 144);
        customRegularFuncMap.put(295, 145);
        customRegularFuncMap.put(785, 146);
        customRegularFuncMap.put(786, 147);
        customRegularFuncMap.put(301, 148);
        customRegularFuncMap.put(302, 31);
        customRegularFuncMap.put(308, 5);
        customRegularFuncMap.put(789, 5);
        customRegularFuncMap.put(791, 151);
        customRegularFuncMap.put(793, 152);
        customRegularFuncMap.put(794, 153);
        customRegularFuncMap.put(795, 154);
        customRegularFuncMap.put(792, 155);
        customRegularFuncMap.put(797, 156);
        customRegularFuncMap.put(317, 157);
        customRegularFuncMap.put(318, 158);
        customRegularFuncMap.put(798, 160);
        customRegularFuncMap.put(799, 159);
        customRegularFuncMap.put(521, 161);
        customRegularFuncMap.put(804, 23);
        customRegularFuncMap.put(810, 163);
        customRegularFuncMap.put(808, 165);
        customRegularFuncMap.put(809, 166);
        customRegularFuncMap.put(346, 167);
        customRegularFuncMap.put(347, 168);
        customRegularFuncMap.put(350, 169);
        customRegularFuncMap.put(817, 170);
        customRegularFuncMap.put(815, 171);
        customRegularFuncMap.put(816, 172);
        customRegularFuncMap.put(818, 173);
        customRegularFuncMap.put(823, 174);
        customRegularFuncMap.put(824, 175);
        customRegularFuncMap.put(825, 176);
        customRegularFuncMap.put(826, 177);
        customRegularFuncMap.put(830, 178);
        customRegularFuncMap.put(827, 179);
        customRegularFuncMap.put(828, 180);
        customRegularFuncMap.put(829, 181);
        customRegularFuncMap.put(831, 182);
        customRegularFuncMap.put(832, 183);
        customRegularFuncMap.put(833, 184);
        customRegularFuncMap.put(834, 185);
        customRegularFuncMap.put(355, 186);
        customRegularFuncMap.put(835, 187);
        customRegularFuncMap.put(363, 188);
        customRegularFuncMap.put(839, 27);
        customRegularFuncMap.put(842, 193);
        customRegularFuncMap.put(843, 192);
        customRegularFuncMap.put(811, 164);
        customRegularFuncMap.put(840, 189);
        customRegularFuncMap.put(841, 190);
        customRegularFuncMap.put(846, 191);
        customRegularFuncMap.put(849, 5);
        customRegularFuncMap.put(393, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(821, 43);
        customValueFuncMap.put(750, 52);
        tsiTokensForStringPart = new IntValueHashMap();
        tsiTokensForStringPart.put("yy", 900);
        tsiTokensForStringPart.put("yyyy", 900);
        tsiTokensForStringPart.put("year", 900);
        tsiTokensForStringPart.put("qq", 899);
        tsiTokensForStringPart.put("quarter", 899);
        tsiTokensForStringPart.put("mm", 898);
        tsiTokensForStringPart.put("month", 898);
        tsiTokensForStringPart.put("dd", 896);
        tsiTokensForStringPart.put("day", 896);
        tsiTokensForStringPart.put("dy", 666);
        tsiTokensForStringPart.put("dayofyear", 666);
        tsiTokensForStringPart.put("dw", 665);
        tsiTokensForStringPart.put("weekday", 665);
        tsiTokensForStringPart.put("wk", 897);
        tsiTokensForStringPart.put("week", 897);
        tsiTokensForStringPart.put("hh", 895);
        tsiTokensForStringPart.put("hour", 895);
        tsiTokensForStringPart.put("mi", 894);
        tsiTokensForStringPart.put("minute", 894);
        tsiTokensForStringPart.put("ss", 893);
        tsiTokensForStringPart.put("second", 893);
        tsiTokensForStringPart.put("ms", 891);
        tsiTokensForStringPart.put("millisecond", 891);
        tsiTokensForStringPart.put("mcs", 892);
        tsiTokensForStringPart.put("microsecond", 892);
        tsiTokensForStringPart.put("ns", 890);
        tsiTokensForStringPart.put("nanosecond", 890);
        tsiTokensForStringPart.put("tz", 818);
        tsiTokensForStringPart.put("tzoffset", 818);
        tokensForTSIPart = new IntKeyIntValueHashMap();
        tokensForTSIPart.put(890, 743);
        tokensForTSIPart.put(891, 734);
        tokensForTSIPart.put(893, 308);
        tokensForTSIPart.put(894, 215);
        tokensForTSIPart.put(895, 151);
        tokensForTSIPart.put(896, 88);
        tokensForTSIPart.put(665, 665);
        tokensForTSIPart.put(666, 666);
        tokensForTSIPart.put(818, 818);
        tokensForTSIPart.put(897, 850);
        tokensForTSIPart.put(898, 219);
        tokensForTSIPart.put(899, 764);
        tokensForTSIPart.put(900, 393);
        sqlTypeForToken = new IntValueHashMap();
        sqlTypeForToken.put("YEAR_MONTH", 107);
        sqlTypeForToken.put("DAY_HOUR", 108);
        sqlTypeForToken.put("DAY_MINUTE", 109);
        sqlTypeForToken.put("DAY_SECOND", 110);
        sqlTypeForToken.put("DAY_MICROSECOND", 110);
        sqlTypeForToken.put("HOUR_MINUTE", 111);
        sqlTypeForToken.put("HOUR_SECOND", 112);
        sqlTypeForToken.put("HOUR_MICROSECOND", 112);
        sqlTypeForToken.put("MINUTE_SECOND", 113);
        sqlTypeForToken.put("MINUTE_MICROSECOND", 113);
        sqlTypeForToken.put("SECOND_MICROSECOND", 106);
    }
}

