/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.ExpressionColumn;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.PeriodDefinition;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.Set;

public class ExpressionPeriod
extends Expression {
    PeriodDefinition period;
    ExpressionColumn columnExpr;

    ExpressionPeriod() {
        super(57);
    }

    ExpressionPeriod(Expression expression, Expression expression2) {
        super(57);
        this.nodes = new Expression[]{expression, expression2};
    }

    ExpressionPeriod(ExpressionColumn expressionColumn) {
        super(57);
        this.columnExpr = expressionColumn;
    }

    ExpressionPeriod(PeriodDefinition periodDefinition) {
        super(57);
        this.period = periodDefinition;
    }

    ExpressionPeriod(Expression expression) {
        super(57);
        this.nodes = expression.nodes;
    }

    boolean isNamedPeriod() {
        return this.period != null;
    }

    int getPeriodType() {
        if (this.period == null) {
            return 0;
        }
        return this.period.getPeriodType();
    }

    void setRangeVariable(RangeVariable rangeVariable) {
        Table table = rangeVariable.getTable();
        this.period = table.getSystemPeriod();
        ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, this.period.startColumn);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable, this.period.endColumn);
        this.nodes = new Expression[]{expressionColumn, expressionColumn2};
    }

    @Override
    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List<Expression> list, boolean bl) {
        for (int i = 0; i < this.nodes.length; ++i) {
            list = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
        }
        RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
        if (this.columnExpr != null) {
            for (int i = 0; i < n; ++i) {
                RangeVariable rangeVariable = rangeVariableArray[i];
                PeriodDefinition periodDefinition = rangeVariable.findPeriod(this.columnExpr.schema, this.columnExpr.tableName, this.columnExpr.columnName);
                if (periodDefinition == null) continue;
                if (this.period == null) {
                    this.period = periodDefinition;
                    ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, this.period.startColumn);
                    ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable, this.period.endColumn);
                    this.nodes = new Expression[]{expressionColumn, expressionColumn2};
                    continue;
                }
                throw Error.error(5516);
            }
            if (this.period == null) {
                throw Error.error(5516);
            }
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
    }

    @Override
    void collectObjectNames(Set<HsqlNameManager.HsqlName> set) {
        if (this.period != null) {
            set.add(this.period.getName());
        }
    }
}

