/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Cursor;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.impl.CursorImpl;
import shaded.io.github.spannm.jackcess.util.ColumnMatcher;

public class IterableBuilder
implements Iterable<Row> {
    private final Cursor _cursor;
    private Type _type = Type.SIMPLE;
    private boolean _forward = true;
    private boolean _reset = true;
    private Collection<String> _columnNames;
    private ColumnMatcher _columnMatcher;
    private Object _matchPattern;

    public IterableBuilder(Cursor cursor) {
        this._cursor = cursor;
    }

    public Collection<String> getColumnNames() {
        return this._columnNames;
    }

    public ColumnMatcher getColumnMatcher() {
        return this._columnMatcher;
    }

    public boolean isForward() {
        return this._forward;
    }

    public boolean isReset() {
        return this._reset;
    }

    public Object getMatchPattern() {
        return this._matchPattern;
    }

    public Type getType() {
        return this._type;
    }

    public IterableBuilder forward() {
        return this.withForward(true);
    }

    public IterableBuilder reverse() {
        return this.withForward(false);
    }

    public IterableBuilder withForward(boolean forward) {
        this._forward = forward;
        return this;
    }

    public IterableBuilder reset(boolean reset) {
        this._reset = reset;
        return this;
    }

    public IterableBuilder withColumnNames(Collection<String> columnNames) {
        this._columnNames = columnNames;
        return this;
    }

    public IterableBuilder addColumnNames(Iterable<String> columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    public IterableBuilder addColumns(Iterable<? extends Column> cols) {
        if (cols != null) {
            for (Column column : cols) {
                this.addColumnName(column.getName());
            }
        }
        return this;
    }

    public IterableBuilder addColumnNames(String ... columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    private void addColumnName(String columnName) {
        if (this._columnNames == null) {
            this._columnNames = new HashSet<String>();
        }
        this._columnNames.add(columnName);
    }

    public IterableBuilder withMatchPattern(Column columnPattern, Object valuePattern) {
        this._type = Type.COLUMN_MATCH;
        this._matchPattern = new AbstractMap.SimpleImmutableEntry<Column, Object>(columnPattern, valuePattern);
        return this;
    }

    public IterableBuilder withMatchPattern(String columnNamePattern, Object valuePattern) {
        return this.withMatchPattern(this._cursor.getTable().getColumn(columnNamePattern), valuePattern);
    }

    public IterableBuilder withMatchPattern(Map<String, ?> rowPattern) {
        this._type = Type.ROW_MATCH;
        this._matchPattern = rowPattern;
        return this;
    }

    public IterableBuilder addMatchPattern(String columnNamePattern, Object valuePattern) {
        this._type = Type.ROW_MATCH;
        HashMap<String, Object> matchPattern = (HashMap<String, Object>)this._matchPattern;
        if (matchPattern == null) {
            this._matchPattern = matchPattern = new HashMap<String, Object>();
        }
        matchPattern.put(columnNamePattern, valuePattern);
        return this;
    }

    public IterableBuilder withColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    @Override
    public Iterator<Row> iterator() {
        return ((CursorImpl)this._cursor).iterator(this);
    }

    public Stream<Row> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static enum Type {
        SIMPLE,
        COLUMN_MATCH,
        ROW_MATCH;

    }
}

